/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.feign.impl;

import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.hotent.base.feign.impl.FallbackFeignServiceHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.cloud.openfeign.FallbackFactory;

public abstract class AbstractFallbackFeignServiceFactory<T>
implements FallbackFactory<T> {
    public T create(Throwable cause) {
        Class<T> serviceInterface = this.getFeignServiceClass();
        FallbackFeignServiceHandler handler = new FallbackFeignServiceHandler(serviceInterface.getSimpleName(), cause);
        return this.generateProxy(serviceInterface, handler);
    }

    public Class<T> getFeignServiceClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), (int)0);
    }

    private T generateProxy(Class<T> serviceInterface, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, handler);
    }
}

