/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.filter;

import com.hotent.base.conf.EipYmlConfig;
import com.hotent.base.conf.SecurityConfig;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.request.SqlInjectHttpServletRequestWrapper;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="SqlInjectFilter", urlPatterns={"/*"})
public class SqlInjectFilter
implements Filter {
    @Resource
    SecurityConfig securityConfig;
    @Resource
    EipYmlConfig eipYmlConfig;
    @Value(value="${jwt.header:Authorization}")
    String tokenHeader;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestHeader = request.getHeader(this.tokenHeader);
        if (requestHeader != null && requestHeader.startsWith("Bearer ") && !this.eipYmlConfig.getAnonymousUrl().contains(request.getRequestURI())) {
            String token = requestHeader.substring(7);
            JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
            jwtTokenHandler.validTokenAlg(token);
        }
        if (!this.securityConfig.isEnabled() || this.isExcludeUrl(request.getServletPath()) || this.isUploadUrl(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        SqlInjectHttpServletRequestWrapper sqlInjectHttpServletRequestWrapper = new SqlInjectHttpServletRequestWrapper(request);
        filterChain.doFilter((ServletRequest)sqlInjectHttpServletRequestWrapper, servletResponse);
    }

    public void destroy() {
    }

    private boolean isExcludeUrl(String url) {
        List<String> sqlExcludes = this.securityConfig.getSqlExcludes();
        if (BeanUtils.isEmpty(sqlExcludes)) {
            return false;
        }
        return sqlExcludes.stream().map(pattern -> Pattern.compile("^" + pattern)).map(p -> p.matcher(url)).anyMatch(Matcher::find);
    }

    private boolean isUploadUrl(HttpServletRequest request) {
        String contentType = request.getContentType();
        return StringUtil.isNotEmpty(contentType) && contentType.toLowerCase().contains("multipart/form-data;");
    }
}

