/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.conf.PermissionCacheCleanConfig;
import com.hotent.base.util.AppUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class PermissionCacheCleanPlugin
implements Interceptor {
    @Resource
    PermissionCacheCleanConfig permissionCacheCleanConfig;
    static final Set<String> CLEAN_CACHE_TABLE_NAMES = Arrays.stream(new String[]{"uc_user", "uc_role", "uc_org", "uc_org_post", "uc_org_job", "uc_org_user", "uc_org_post", "uc_user_role"}).collect(Collectors.toSet());

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args.length < 2) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)args[0];
        String sql = ms.getBoundSql(args[1]).getSql();
        List<String> tableNames = this.getTableNames(sql);
        Set<String> cacheCleanTables = CLEAN_CACHE_TABLE_NAMES;
        if (CollUtil.isNotEmpty(this.permissionCacheCleanConfig.getCacheCleanTables())) {
            cacheCleanTables.addAll(this.permissionCacheCleanConfig.getCacheCleanTables());
        }
        for (String tableName : tableNames) {
            for (String s : cacheCleanTables) {
                if (!s.equalsIgnoreCase(tableName)) continue;
                AppUtil.getBean(PermissionCacheCleanPlugin.class).cleanCurrentProfilesCache();
                return invocation.proceed();
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }

    public <C> C getByPropertyName(Object obj, String name) throws Exception {
        Class<?> c = obj.getClass();
        Field f = c.getDeclaredField(name);
        f.setAccessible(true);
        return (C)f.get(obj);
    }

    public List<String> getTableNames(String sql) throws Exception {
        Statements statements = CCJSqlParserUtil.parseStatements((String)sql);
        List statementsList = statements.getStatements();
        ArrayList<String> tableNames = new ArrayList<String>();
        statementsList.forEach(statement -> tableNames.addAll(new TablesNamesFinder().getTableList(statement)));
        return tableNames;
    }

    @CacheEvict(value={"eip:uc:currentProfiles"}, allEntries=true)
    public void cleanCurrentProfilesCache() {
    }
}

