/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.interceptor;

import com.hotent.base.interceptor.ResultSetFilter;
import com.hotent.base.util.BeanUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.util.Assert;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class ResultSetInterceptor
implements Interceptor {
    private CopyOnWriteArrayList<ResultSetFilter> filters = new CopyOnWriteArrayList();
    private final List<String> MAPPED_STATEMENT_IDS = Arrays.asList("com.hotent.bpm.persistence.dao.BpmTaskDao.getByUserId", "com.hotent.bpm.persistence.dao.BpmTaskDao.getCountByUserIdWithWhere", "com.hotent.base.dao.CommonDao.documentationQueryByField");

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            Object target = invocation.getTarget();
            MappedStatement ms = (MappedStatement)this.getByPropertyName(target, "mappedStatement");
            BoundSql boundSql = (BoundSql)this.getByPropertyName(target, "boundSql");
            String id = ms.getId();
            Object result = invocation.proceed();
            if (this.MAPPED_STATEMENT_IDS.contains(id)) {
                return result;
            }
            String sql = boundSql.getSql();
            List<String> tableNames = this.getTableNames(sql);
            for (ResultSetFilter f : this.filters) {
                if (!f.support(id, sql, tableNames)) continue;
                f.handle(result);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return invocation.proceed();
        }
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            if (BeanUtils.isEmpty(this.filters)) {
                return target;
            }
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public <C> C getByPropertyName(Object obj, String name) throws Exception {
        Class<?> c = obj.getClass();
        Field f = c.getDeclaredField(name);
        f.setAccessible(true);
        return (C)f.get(obj);
    }

    public List<String> getTableNames(String sql) throws Exception {
        net.sf.jsqlparser.statement.Statement statement = new CCJSqlParserManager().parse((Reader)new StringReader(sql));
        return new TablesNamesFinder().getTableList(statement);
    }

    public void setFilters(CopyOnWriteArrayList<ResultSetFilter> filters) {
        Assert.notNull(filters, (String)"filters can not be empty.");
        this.filters = filters;
    }

    public void addFilters(ResultSetFilter filter) {
        Assert.notNull((Object)filter, (String)"filters can not be empty.");
        this.filters.add(filter);
    }
}

