/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.manager;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.conf.QueryFilterConfig;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.query.SelectColumn;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FieldConvertUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public interface QueryFilterHelper<T> {
    public static final String INJECTION_REGEX = "[A-Za-z0-9\\_\\-\\+\\.]+";
    public static final String WHERE_SQL_TAG = "whereSql";
    public static final String ORDER_SQL_TAG = "orderBySql";

    default public IPage<T> convert2IPage(PageBean pageBean) {
        return pageBean == null ? new Page() : new Page((long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue(), pageBean.showTotal());
    }

    default public void addConditionToWapper(String group, Map<String, String> groupTree, QueryWrapper<T> queryWrapper, Map<String, List<QueryField>> groupQueryField, Class<T> currentModelClass) {
        List<QueryField> fields = groupQueryField.get(group);
        if (BeanUtils.isNotEmpty(fields)) {
            fields.forEach(l -> this.convertQueryField(queryWrapper, (QueryField)l, currentModelClass));
            FieldRelation groupRelation = fields.get(0).getRelation();
            if (FieldRelation.OR.equals((Object)groupRelation)) {
                queryWrapper.or();
            }
            groupTree.forEach((groupChild, parentGroup) -> {
                if (StringUtil.isNotEmpty(parentGroup) && parentGroup.equals(group)) {
                    queryWrapper.nested(BeanUtils.isNotEmpty(groupQueryField.get(groupChild)), w -> this.addConditionToWapper((String)groupChild, groupTree, (QueryWrapper<T>)w, groupQueryField, currentModelClass));
                }
            });
        }
    }

    default public Wrapper<T> convert2Wrapper(QueryFilter<?> queryFilter, Class<T> currentModelClass) {
        SelectColumn selectColumn;
        QueryWrapper queryWrapper = new QueryWrapper();
        Map<String, List<QueryField>> groupQueryField = queryFilter.groupQueryField();
        Map<String, String> groupTree = queryFilter.getGroupTree();
        List<String> roots = queryFilter.getRootGroup(groupTree);
        FieldRelation groupRelation = queryFilter.getGroupRelation();
        roots.forEach(group -> {
            if (FieldRelation.OR.equals((Object)groupRelation)) {
                queryWrapper.or();
            }
            queryWrapper.nested(BeanUtils.isNotEmpty(groupQueryField.get(group)), w -> this.addConditionToWapper((String)group, groupTree, (QueryWrapper<T>)w, groupQueryField, currentModelClass));
        });
        List<FieldSort> fieldSortList = queryFilter.getSorter();
        fieldSortList.forEach(item -> {
            if (Direction.DESC.equals((Object)item.getDirection())) {
                queryWrapper.orderByDesc((Object)this.convertSortField((FieldSort)item, currentModelClass));
            } else {
                queryWrapper.orderByAsc((Object)this.convertSortField((FieldSort)item, currentModelClass));
            }
        });
        Map<String, Object> params = queryFilter.getParams();
        if (params != null && params.size() > 0) {
            Map paramNameValuePairs = queryWrapper.getParamNameValuePairs();
            paramNameValuePairs.putAll(params);
        }
        if (BeanUtils.isNotEmpty(selectColumn = queryFilter.getSelectColumn())) {
            if (BeanUtils.isNotEmpty(selectColumn.getCols())) {
                String[] strings = selectColumn.getCols().stream().map(f -> this.convertField((String)f, currentModelClass)).collect(Collectors.toList()).toArray(new String[selectColumn.getCols().size()]);
                queryWrapper.select(strings);
            } else if (BeanUtils.isNotEmpty(selectColumn.getExclusionCols())) {
                Set collect = selectColumn.getExclusionCols().stream().map(f -> this.convertField((String)f, currentModelClass).toLowerCase()).collect(Collectors.toSet());
                queryWrapper.select(currentModelClass, info -> !collect.contains(info.getColumn().toLowerCase()));
            }
        }
        return queryWrapper;
    }

    default public String convertSortField(FieldSort fieldSort, Class<T> currentModelClass) {
        if (fieldSort == null) {
            return null;
        }
        if (currentModelClass != null) {
            return FieldConvertUtil.property2Field(fieldSort.getProperty(), currentModelClass);
        }
        return fieldSort.getProperty();
    }

    default public String convertField(String field, Class<T> currentModelClass) {
        if (field == null) {
            return null;
        }
        if (currentModelClass != null) {
            return FieldConvertUtil.property2Field(field, currentModelClass);
        }
        return field;
    }

    default public void convertQueryField(QueryWrapper<T> queryWrapper, QueryField queryField, Class<T> currentModelClass) {
        QueryFilterConfig queryFilterConfig = AppUtil.getBean(QueryFilterConfig.class);
        FieldRelation r = queryField.getRelation();
        if (FieldRelation.OR.equals((Object)r)) {
            queryWrapper.or();
        }
        String field = queryField.getProperty();
        if (currentModelClass != null) {
            field = FieldConvertUtil.property2Field(field, currentModelClass);
        }
        String dbType = SQLUtil.getDbType();
        QueryOP operation = queryField.getOperation();
        switch (operation) {
            case EQUAL: 
            case EQUAL_IGNORE_CASE: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Object date = null;
                    if (queryField.getValue() instanceof String) {
                        if (DateUtil.isRqFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd");
                        } else if (DateUtil.isRqSjFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd HH:mm:ss");
                        }
                    }
                    queryWrapper.eq((Object)field, BeanUtils.isNotEmpty(date) ? date : queryField.getValue());
                    break;
                }
                queryWrapper.eq((Object)field, queryField.getValue());
                break;
            }
            case NOT_EQUAL: {
                queryWrapper.ne((Object)field, queryField.getValue());
                break;
            }
            case LESS: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Object date = null;
                    if (queryField.getValue() instanceof String) {
                        if (DateUtil.isRqFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd");
                        } else if (DateUtil.isRqSjFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd HH:mm:ss");
                        }
                    }
                    queryWrapper.lt((Object)field, BeanUtils.isNotEmpty(date) ? date : queryField.getValue());
                    break;
                }
                queryWrapper.lt((Object)field, queryField.getValue());
                break;
            }
            case GREAT: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Object date = null;
                    if (queryField.getValue() instanceof String) {
                        if (DateUtil.isRqFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd");
                        } else if (DateUtil.isRqSjFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd HH:mm:ss");
                        }
                    }
                    queryWrapper.gt((Object)field, BeanUtils.isNotEmpty(date) ? date : queryField.getValue());
                    break;
                }
                queryWrapper.gt((Object)field, queryField.getValue());
                break;
            }
            case LESS_EQUAL: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Object date = null;
                    if (queryField.getValue() instanceof String) {
                        if (DateUtil.isRqFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd");
                        } else if (DateUtil.isRqSjFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd HH:mm:ss");
                        }
                    }
                    queryWrapper.le((Object)field, BeanUtils.isNotEmpty(date) ? date : queryField.getValue());
                    break;
                }
                queryWrapper.le((Object)field, queryField.getValue());
                break;
            }
            case GREAT_EQUAL: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Object date = null;
                    if (queryField.getValue() instanceof String) {
                        if (DateUtil.isRqFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd");
                        } else if (DateUtil.isRqSjFormat(String.valueOf(queryField.getValue()))) {
                            date = this.convertStringToDate(String.valueOf(queryField.getValue()), "yyyy-MM-dd HH:mm:ss");
                        }
                    }
                    queryWrapper.ge((Object)field, BeanUtils.isNotEmpty(date) ? date : queryField.getValue());
                    break;
                }
                queryWrapper.ge((Object)field, queryField.getValue());
                break;
            }
            case LIKE: {
                queryWrapper.like((Object)field, queryFilterConfig.escapeValue(queryField.getValue()));
                break;
            }
            case LEFT_LIKE: {
                queryWrapper.likeLeft((Object)field, queryField.getValue());
                break;
            }
            case RIGHT_LIKE: {
                queryWrapper.likeRight((Object)field, queryField.getValue());
                break;
            }
            case IS_NULL: {
                queryWrapper.isNull((Object)field);
                break;
            }
            case NOTNULL: {
                queryWrapper.isNotNull((Object)field);
                break;
            }
            case IN: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    this.cutInParameter(queryWrapper, this.convert2ObjectArray(queryField.getValue()), field);
                    break;
                }
                queryWrapper.in((Object)field, this.convert2ObjectArray(queryField.getValue()));
                break;
            }
            case NOT_IN: {
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    this.cutNotInParameter(queryWrapper, this.convert2ObjectArray(queryField.getValue()), field);
                    break;
                }
                queryWrapper.notIn((Object)field, this.convert2ObjectArray(queryField.getValue()));
                break;
            }
            case BETWEEN: {
                Object[] objs = this.convert2ObjectArray(queryField.getValue());
                Assert.notNull((Object)objs, (String)String.format("\u67e5\u8be2\u6761\u4ef6\uff1a%s\u7684\u67e5\u8be2\u503c\u4e3a\u7a7a", field));
                Assert.isTrue((objs.length == 2 ? 1 : 0) != 0, (String)String.format("\u67e5\u8be2\u6761\u4ef6\u4e3abetween\u65f6\uff0c\u67e5\u8be2\u503c\u5fc5\u987b\u4e3a\u4e24\u4e2a\uff0c\u4f46\u662f\u4f20\u5165\u7684\u67e5\u8be2\u503c\u4e3a\uff1a%s", objs));
                if (DbType.ORACLE.getDb().equals(dbType)) {
                    Date[] dates = new Date[2];
                    if (objs[0] instanceof String) {
                        dates[0] = this.convertStringToDate(String.valueOf(objs[0]), DateUtil.isRqFormat(String.valueOf(objs[0])) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    }
                    if (objs[1] instanceof String) {
                        dates[1] = this.convertStringToDate(String.valueOf(objs[1]), DateUtil.isRqFormat(String.valueOf(objs[1])) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
                    }
                    queryWrapper.between((Object)field, BeanUtils.isNotEmpty(dates[0]) ? dates[0] : objs[0], BeanUtils.isNotEmpty(dates[1]) ? dates[1] : objs[1]);
                    break;
                }
                if (DbType.POSTGRE_SQL.getDb().equals(dbType)) {
                    queryWrapper.between((Object)field, (Object)Timestamp.valueOf(String.valueOf(objs[0])), (Object)Timestamp.valueOf(String.valueOf(objs[1])));
                    break;
                }
                queryWrapper.between((Object)field, objs[0], objs[1]);
                break;
            }
        }
    }

    default public Date convertStringToDate(String str, String type) {
        SimpleDateFormat dd = new SimpleDateFormat(type);
        Date result = null;
        try {
            result = dd.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    default public Object[] convert2ObjectArray(Object obj) {
        if (BeanUtils.isEmpty(obj)) {
            return new Object[]{"''"};
        }
        if (obj instanceof String) {
            String str = obj.toString();
            Object[] split = str.split(",");
            for (int i = 0; i < split.length; ++i) {
                split[i] = this.handleQuotation((String)split[i]);
            }
            return split;
        }
        if (obj instanceof List) {
            List objList = (List)obj;
            return objList.toArray();
        }
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        if (obj instanceof Object) {
            return new Object[]{obj};
        }
        return null;
    }

    default public String handleQuotation(String str) {
        String ResultString = str;
        try {
            Pattern regex = Pattern.compile("^'(.*)'$");
            Matcher regexMatcher = regex.matcher(str);
            if (regexMatcher.find()) {
                ResultString = regexMatcher.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return ResultString;
    }

    default public void copyQuerysInParams(QueryFilter queryFilter) {
        List<QueryField> querys = queryFilter.getQuerys();
        Map<String, Object> params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty(querys)) {
            querys.forEach(i -> {
                if (!params.containsKey(i.getProperty())) {
                    params.put(i.getProperty(), i.getValue());
                }
            });
        }
    }

    default public <F> void cutInParameter(QueryWrapper<T> queryWrapper, Object[] coll, String field) {
        List<List<Object>> newList = this.splitList(coll, 900);
        if (BeanUtils.isEmpty(newList)) {
            Assert.notNull((Object)coll, (String)String.format("\u67e5\u8be2\u6761\u4ef6\uff1a%s\u7684\u53c2\u6570\u9519\u8bef", field));
        } else if (newList.size() == 1) {
            queryWrapper.in((Object)field, (Collection)newList.get(0));
            return;
        }
        queryWrapper.and(i -> {
            i.in((Object)field, (Collection)newList.get(0));
            newList.remove(0);
            for (List objects : newList) {
                ((QueryWrapper)i.or()).in((Object)field, (Collection)objects);
            }
        });
    }

    default public <F> void cutNotInParameter(QueryWrapper<T> queryWrapper, Object[] coll, String field) {
        List<List<Object>> newList = this.splitList(coll, 900);
        if (BeanUtils.isEmpty(newList)) {
            Assert.notNull((Object)coll, (String)String.format("\u67e5\u8be2\u6761\u4ef6\uff1a%s\u7684\u53c2\u6570\u9519\u8bef", field));
        } else if (newList.size() == 1) {
            queryWrapper.notIn((Object)field, (Collection)newList.get(0));
            return;
        }
        queryWrapper.and(i -> {
            i.notIn((Object)field, (Collection)newList.get(0));
            newList.remove(0);
            for (List objects : newList) {
                ((QueryWrapper)i.or()).notIn((Object)field, (Collection)objects);
            }
        });
    }

    default public <F> List<List<Object>> splitList(Object[] list, int groupSize) {
        if (BeanUtils.isEmpty(list)) {
            Assert.notNull((Object)list, (String)"\u53c2\u6570\u9519\u8bef");
        }
        ArrayList<Object> objects = new ArrayList<Object>(Arrays.asList(list));
        int length = objects.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<Object>> newList = new ArrayList<List<Object>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = Math.min((i + 1) * groupSize, length);
            newList.add(objects.subList(fromIndex, toIndex));
        }
        return newList;
    }
}

