/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.manager.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.dao.CommonDao;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.SystemException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.QueryFilterHelper;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DefaultCommonManager
implements CommonManager,
QueryFilterHelper<Map<String, Object>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_BATCH_SIZE = 1000;
    @Resource
    CommonDao commonDao;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public int execute(String sql) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        return this.execute(sql, new HashMap<String, Object>());
    }

    private String convertToMap(Map<String, Object> map, String sql, Object ... objs) {
        Assert.notNull(map, (String)"map\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty(sql), (String)"sql\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)BeanUtils.isNotEmpty(objs), (String)"objs\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern pattern = Pattern.compile("(\\?)");
        Matcher matcher = pattern.matcher(sql);
        StringBuffer sb = new StringBuffer();
        int count = 0;
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.format("#{key%s}", count));
            ++count;
        }
        matcher.appendTail(sb);
        if (count != objs.length) {
            throw new BaseException(String.format("sql\uff1a%s\u4e2d\u53c2\u6570\u5316\u7684\u6570\u91cf\u548c\u4f20\u9012\u8fdb\u6765\u7684\u53c2\u6570\uff1a%s\u6570\u91cf\u4e0d\u5339\u914d\u3002", sql, objs));
        }
        map.clear();
        for (int i = 0; i < objs.length; ++i) {
            map.put("key" + i, objs[i]);
        }
        return sb.toString();
    }

    @Override
    public int execute(String sql, Object ... objs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String newSql = this.convertToMap(map, sql, objs);
        return this.execute(newSql, map);
    }

    @Override
    public int execute(String sql, Map<String, Object> map) {
        map.put("sql", sql);
        return this.commonDao.update(map);
    }

    @Override
    public List<Map<String, Object>> query(String sql) {
        return this.query(sql, new HashMap<String, Object>());
    }

    @Override
    public List<Map<String, Object>> query(String sql, Object ... objs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String newSql = this.convertToMap(map, sql, objs);
        return this.query(newSql, map);
    }

    @Override
    public List<Map<String, Object>> query(String sql, Map<String, Object> map) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(map, (String)"map can not be empty.");
        if (map.containsKey("sql")) {
            this.logger.warn("can not define 'sql' in map when invoke CommonManager.query(sql, map), it will be override by sql string.");
        }
        map.put("sql", sql);
        return this.commonDao.query(map);
    }

    @Override
    public PageList<Map<String, Object>> query(String sql, PageBean pageBean) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        IPage<Map<String, Object>> result = this.commonDao.queryByPage(this.convert2IPage(pageBean), sql);
        return new PageList<Map<String, Object>>(result);
    }

    @Override
    public PageList<Map<String, Object>> query(String sql, QueryFilter<?> queryFilter) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(queryFilter, (String)"queryFilter can not be empty.");
        PageBean pageBean = queryFilter.getPageBean();
        IPage<Map<String, Object>> result = this.commonDao.queryByQueryFilter(this.convert2IPage(pageBean), sql, this.convert2Wrapper(queryFilter, null));
        return new PageList<Map<String, Object>>(result);
    }

    @Override
    public PageList<Map<String, Object>> queryByCustomSql(String sql, QueryFilter<?> queryFilter) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(queryFilter, (String)"queryFilter can not be empty.");
        PageBean pageBean = queryFilter.getPageBean();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        IPage<Map<String, Object>> result = this.commonDao.queryByCustomSql(this.convert2IPage(pageBean), sql, this.convert2Wrapper(queryFilter, null));
        return new PageList<Map<String, Object>>(result);
    }

    @Override
    public List<Map<String, Object>> queryByCustomSqlNoPage(String sql, QueryFilter<?> queryFilter) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(queryFilter, (String)"queryFilter can not be empty.");
        List<Map<String, Object>> result = this.commonDao.queryByCustomSql(sql, this.convert2Wrapper(queryFilter, null));
        return result;
    }

    @Override
    public int batchInsert(String tableName, List<Map<String, Object>> valueList, int batchSize) {
        String dbType = this.databaseContext.getDbType();
        long currentTimeMillis = System.currentTimeMillis();
        int size = valueList.size();
        int i = 1;
        int update = 0;
        ArrayList<Map<String, Object>> group = new ArrayList<Map<String, Object>>();
        Map<String, Object> stringObjectMap = valueList.get(0);
        Set<String> fieldNames = stringObjectMap.keySet();
        StringJoiner sj = new StringJoiner(",");
        fieldNames.stream().forEach(fieldName -> sj.add((CharSequence)fieldName));
        String insertFields = sj.toString();
        for (Map<String, Object> element : valueList) {
            if (BeanUtils.isEmpty(element)) continue;
            group.add(element);
            if (i % batchSize == 0 || i == size) {
                update = "oracle".equals(dbType) ? (update += this.commonDao.batchInsert4Oracle(tableName, insertFields, group)) : (update += this.commonDao.batchInsert(tableName, insertFields, group));
                group.clear();
            }
            ++i;
        }
        if (BeanUtils.isNotEmpty(group)) {
            int result = 0;
            result = "oracle".equals(dbType) ? (result += this.commonDao.batchInsert4Oracle(tableName, insertFields, group)) : (result += this.commonDao.batchInsert(tableName, insertFields, group));
            if (result == 1) {
                update += group.size();
            }
        }
        this.logger.info("\u6279\u91cf\u63d2\u5165{}\u8868{}\u6761\u6570\u636e\u8017\u65f6{}", new Object[]{tableName, update, System.currentTimeMillis() - currentTimeMillis});
        return update;
    }

    @Override
    public int batchInsert(String tableName, List<Map<String, Object>> valueList) {
        return this.batchInsert(tableName, valueList, this.getDefaultBatchSize());
    }

    @Override
    public int batchUpdate(String tableName, String pkField, List<Map<String, Object>> valueMap, int batchSize) {
        return this.batchUpdate(tableName, pkField, valueMap, batchSize, false);
    }

    @Override
    public int batchUpdate(String tableName, String pkField, List<Map<String, Object>> valueList) {
        return this.batchUpdate(tableName, pkField, valueList, this.getDefaultBatchSize());
    }

    @Override
    public int batchDelete(String tableName, String pkField, List<String> batchParams, int batchSize) {
        Assert.hasText((String)pkField, (String)"pkField must not empty");
        int size = batchParams.size();
        int i = 1;
        ArrayList<String> group = new ArrayList<String>();
        for (String pkValue : batchParams) {
            if (StringUtil.isEmpty(pkValue)) continue;
            group.add(pkValue);
            if (i % batchSize == 0 || i == size) {
                this.commonDao.batchDelete(tableName, pkField, group);
                group.clear();
            }
            ++i;
        }
        if (BeanUtils.isNotEmpty(group)) {
            this.commonDao.batchDelete(tableName, pkField, group);
        }
        return batchParams.size();
    }

    @Override
    public int batchDelete(String tableName, String pkField, List<String> batchParams) {
        return this.batchDelete(tableName, pkField, batchParams, this.getDefaultBatchSize());
    }

    @Override
    public int updateByCustom(String tableName, String pkField, Map<String, ?> map) {
        return this.commonDao.updateByCustom(tableName, pkField, map);
    }

    @Override
    public int batchUpdate(String tableName, String pkField, List<Map<String, Object>> valueMap, Boolean ignoreDataVersion) {
        return this.batchUpdate(tableName, pkField, valueMap, this.getDefaultBatchSize(), ignoreDataVersion);
    }

    @Override
    public int batchUpdate(String tableName, String pkField, List<Map<String, Object>> valueMap, int batchSize, Boolean ignoreDataVersion) {
        DatabaseContext bean = AppUtil.getBean(DatabaseContext.class);
        String dbType = bean.getDbType();
        boolean supportBatch = true;
        if (DbType.ORACLE.getDb().equals(dbType)) {
            supportBatch = false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        int size = valueMap.size();
        int i = 1;
        ArrayList<Map<String, Object>> group = new ArrayList<Map<String, Object>>();
        int update = 0;
        for (Map<String, Object> element : valueMap) {
            if (BeanUtils.isEmpty(element)) continue;
            group.add(element);
            if (i % batchSize == 0 || i == size) {
                int result;
                int n = result = supportBatch || i == 1 ? this.commonDao.batchUpdate(tableName, pkField, group, ignoreDataVersion) : this.singleUpdate(tableName, pkField, group, ignoreDataVersion);
                if (result == 1 || result == -1) {
                    update += group.size();
                }
                group.clear();
            }
            ++i;
        }
        if (BeanUtils.isNotEmpty(group)) {
            int result;
            int n = result = supportBatch || i == 1 ? this.commonDao.batchUpdate(tableName, pkField, group, ignoreDataVersion) : this.singleUpdate(tableName, pkField, group, ignoreDataVersion);
            if (result == 1) {
                update += group.size();
            }
        }
        this.logger.info("\u6279\u91cf\u66f4\u65b0{}\u8868{}\u6761\u6570\u636e\u8017\u65f6{}", new Object[]{tableName, update, System.currentTimeMillis() - currentTimeMillis});
        return update;
    }

    private int singleUpdate(String tableName, String pkField, List<Map<String, Object>> group, boolean ignoreDataVersion) {
        int result = 0;
        if (BeanUtils.isEmpty(group)) {
            return result;
        }
        for (int i = 0; i < group.size(); ++i) {
            result += this.commonDao.batchUpdate(tableName, pkField, group.subList(i, i + 1), ignoreDataVersion);
        }
        return result;
    }

    private int getDefaultBatchSize() {
        return 1000;
    }
}

