/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.ognl;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.time.DateFormatUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ognl {
    public static boolean isEmpty(Object o) throws IllegalArgumentException {
        return BeanUtils.isEmpty(o);
    }

    public static boolean isNotEmpty(Object o) {
        return !Ognl.isEmpty(o);
    }

    public static boolean isNotEmpty(Long o) {
        return !Ognl.isEmpty(o);
    }

    public static boolean isNumber(Object o) {
        return BeanUtils.isNumber(o);
    }

    public static boolean equals(Object o1, Object o2) {
        return o1.equals(o2);
    }

    public static boolean notEquals(Object o1, Object o2) {
        return !Ognl.equals(o1, o2);
    }

    public static boolean startsWith(Object o1, Object o2) {
        if (o1 == null || !(o1 instanceof String) || o2 == null || !(o2 instanceof String)) {
            return false;
        }
        return o1.toString().trim().startsWith(o2.toString().trim()) || o1.toString().trim().startsWith(o2.toString().trim().toLowerCase()) || o1.toString().trim().startsWith(o2.toString().trim().toUpperCase());
    }

    public static boolean containsWith(Object o1, Object o2) {
        if (o1 == null || !(o1 instanceof String) || o2 == null || !(o2 instanceof String)) {
            return false;
        }
        return o1.toString().trim().contains(o2.toString().trim()) || o1.toString().trim().contains(o2.toString().trim().toLowerCase()) || o1.toString().trim().contains(o2.toString().trim().toUpperCase());
    }

    public static Object withOutWhere(Object o1) {
        String str;
        if (o1 != null && o1 instanceof String && (str = o1.toString().trim()).length() > 6 && (str.startsWith("where") || str.startsWith("WHERE"))) {
            return str.substring(6);
        }
        return o1;
    }

    public static Object insertBeforeOrderBy(Object o1, Object o2) {
        if (Ognl.isEmpty(o2)) {
            return !Ognl.isEmpty(o1) ? o1.toString() : "";
        }
        StringBuilder sql1 = new StringBuilder(Ognl.isNotEmpty(o1) ? o1.toString().trim().replaceAll("\r|\n", " ") : " WHERE ");
        String sql2 = o2.toString().trim().replaceAll("\r|\n", " ") + " ";
        int index = sql1.toString().toUpperCase().indexOf("ORDER BY");
        if (Ognl.isEmpty(o1) || index == 0) {
            if (sql2.toUpperCase().startsWith("AND ")) {
                sql2 = sql2.substring(3, sql2.length());
            } else if (sql2.toUpperCase().startsWith("OR ")) {
                sql2 = sql2.substring(2, sql2.length());
            }
        } else if (!sql2.toUpperCase().startsWith("AND ") && !sql2.toUpperCase().startsWith("OR ")) {
            sql2 = " AND " + sql2;
        }
        if (index > -1) {
            if (sql1.toString().trim().toUpperCase().startsWith("WHERE")) {
                sql1.insert(index, sql2);
                return sql1.toString();
            }
            return String.format(" WHERE %s %s", sql2, sql1.toString());
        }
        return String.format(" %s %s", sql1.toString(), sql2);
    }

    public static boolean containsWhere(Object o) {
        if (BeanUtils.isEmpty(o)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b(where)\\b");
        Matcher matcher = pattern.matcher(o.toString().toLowerCase().replaceAll("\r|\n", " ").replaceAll("\\([\\s\\S]*\\)", ""));
        return matcher.find();
    }

    public static Object encodeValue(List<Map<String, Object>> valueList, int index, String key) {
        String format = String.format("#{valueList[%s].%s}", index, key);
        if (BeanUtils.isNotEmpty(valueList.get(index).get(key)) && valueList.get(index).get(key).toString().startsWith("HEX(AES_ENCRYPT")) {
            return valueList.get(index).get(key).toString();
        }
        return format;
    }

    public static Object documentationEncodeValue(List<Map<String, Object>> valueList, int index, int fieldIndex, String insertFields) {
        Map<String, Object> map = valueList.get(index);
        String[] split = insertFields.split(",");
        Object o = map.get(split[fieldIndex]);
        return Ognl.convertValue(o);
    }

    public static Object documentationEncodeValue(Map<String, Object> map, int fieldIndex, String insertFields) {
        String[] split = insertFields.split(",");
        Object o = map.get(split[fieldIndex]);
        return Ognl.convertValue(o);
    }

    public static Object documentationOracleEncodeValue(List<Map<String, Object>> valueList, int index, int fieldIndex, String insertFields) {
        Map<String, Object> map = valueList.get(index);
        String[] split = insertFields.split(",");
        Object o = map.get(split[fieldIndex]);
        return Ognl.convertOracleValue(o);
    }

    private static Object convertOracleValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Integer || o instanceof Double) {
            return o;
        }
        if (o instanceof LocalDateTime) {
            String time = DateFormatUtil.format((LocalDateTime)o, "yyyy-MM-dd HH:mm:ss");
            return "to_date('" + time + "','yyyy-mm-dd hh24:mi:ss')";
        }
        return "'" + o + "'";
    }

    private static Object convertValue(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Integer || o instanceof Double) {
            return o;
        }
        if (o instanceof LocalDateTime) {
            return "'" + DateFormatUtil.format((LocalDateTime)o, "yyyy-MM-dd HH:mm:ss") + "'";
        }
        return "'" + o + "'";
    }

    public static boolean containsKey(List<Map<String, Object>> valueList, int index, String key) {
        if ("true".equals(ThreadMsgUtil.getMapMsg("ignore_form_data_rev"))) {
            return false;
        }
        return MapUtil.containsIgnoreKey(valueList.get(index), key);
    }

    public static int getOldFormDataRev(List<Map<String, Object>> valueList, int index, String key) {
        Map<String, Object> map = valueList.get(index);
        Object valueOfObj = MapUtil.getIgnoreCase(map, key);
        if (valueOfObj == null) {
            return 0;
        }
        String valueOfStr = String.valueOf(valueOfObj);
        if (StringUtil.isEmpty(valueOfStr) || "null".equalsIgnoreCase(valueOfStr)) {
            return 0;
        }
        Integer value = Integer.parseInt(valueOfStr);
        return value > 0 ? value - 1 : value;
    }

    public static boolean isCollection(Object o) {
        if (BeanUtils.isEmpty(o)) {
            return false;
        }
        return o instanceof Collection;
    }

    public static String replaceHyphensInPlace(String type) {
        return type.replace("-", "_");
    }
}

