/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.security;

import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.crypto.password.PasswordEncoder;

public class CustomPwdEncoder
implements PasswordEncoder {
    private PasswordEncoder delegateEncoder;
    private ThreadLocal<Boolean> ingorePwd = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public void setIngore(boolean ingore) {
        this.ingorePwd.set(ingore);
    }

    public void setDelegateEncoder(PasswordEncoder delegateEncoder) {
        this.delegateEncoder = delegateEncoder;
    }

    public String encode(CharSequence rawPassword) {
        if (this.delegateEncoder != null) {
            return this.delegateEncoder.encode(rawPassword);
        }
        String pwd = rawPassword.toString();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(pwd.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])digest));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public synchronized boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (this.ingorePwd.get().booleanValue()) {
            this.ingorePwd.set(false);
            return true;
        }
        if (this.delegateEncoder != null) {
            return this.delegateEncoder.matches(rawPassword, encodedPassword);
        }
        String enc = this.encode(rawPassword);
        return enc.equals(encodedPassword);
    }
}

