/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.service.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.aop.AopCacheHelper;
import com.hotent.base.exception.BaseException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.service.ExceptionLogService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.WebUtil;
import com.hotent.base.util.time.DateUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExceptionLogServiceImpl
implements ExceptionLogService {
    Logger logger = LoggerFactory.getLogger(ExceptionLogServiceImpl.class);
    private static String MODULE_TYPE = "base";
    private static final String DEFAULT_EXECUTOR = "\u7cfb\u7edf[\u65e0\u7528\u6237\u767b\u5f55\u7cfb\u7edf]";
    private static final String REQUEST_TIME_PROP = "htRequestStartTime";
    private static final String ELAPSED_TIME_PROP = "elapsedTime";
    private static final String LOGGER_ON = "1";
    private static final String LOGGER_OFF = "0";

    @Value(value="${spring.profiles.title: base}")
    public void setModuleType(String param) {
        MODULE_TYPE = param;
    }

    @Override
    public String save(Exception e) {
        String errorContent = ExceptionUtil.getFullStackTrace(e);
        return this.save(errorContent);
    }

    @Override
    public String save(String content) {
        String errorId = UniqueIdUtil.getSuid();
        try {
            if (!this.needLog()) {
                return errorId;
            }
            this.send2Queue(errorId, content);
        }
        catch (Exception err) {
            this.logger.error("\u4fdd\u5b58\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25\u3002", (Throwable)err);
        }
        return errorId;
    }

    private void send2Queue(String errorId, String errorContent) throws IOException {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("id", errorId);
        objectNode.put("opeName", "\u7cfb\u7edf\u5f02\u5e38");
        objectNode.put("moduleType", MODULE_TYPE);
        objectNode.put("opeContent", errorContent);
        objectNode.put("type", "sysLog");
        objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
        objectNode.put("logType", "\u9519\u8bef\u65e5\u5fd7");
        this.putRequestInfo(objectNode);
        this.putExecutor(objectNode);
        this.putTenantId(objectNode);
        JmsProducer jmsProducer = AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysLogQueue");
    }

    private void putRequestInfo(ObjectNode objectNode) {
        HttpServletRequest request = HttpUtil.getRequest();
        if (request == null) {
            throw new BaseException("request\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a");
        }
        String reqUrl = request.getRequestURI();
        if (BeanUtils.isNotEmpty(request.getAttribute(REQUEST_TIME_PROP))) {
            LocalDateTime startTime = (LocalDateTime)request.getAttribute(REQUEST_TIME_PROP);
            objectNode.put(ELAPSED_TIME_PROP, (double)DateUtil.getTime(startTime, LocalDateTime.now()) / 1000.0);
        }
        objectNode.put("reqUrl", reqUrl);
        objectNode.put("ip", WebUtil.getIpAddr(request));
    }

    private void putExecutor(ObjectNode objectNode) {
        String executor = DEFAULT_EXECUTOR;
        if (StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())) {
            executor = String.format("%s[%s]", AuthenticationUtil.getCurrentUserFullname(), AuthenticationUtil.getCurrentUsername());
        }
        objectNode.put("executor", executor);
    }

    private void putTenantId(ObjectNode objectNode) {
        String tenantId = HttpUtil.getTenantId();
        if (BeanUtils.isEmpty(tenantId)) {
            tenantId = "-1";
        }
        objectNode.put("tenantId", tenantId);
    }

    private boolean needLog() {
        AopCacheHelper aopCacheHelper = AppUtil.getBean(AopCacheHelper.class);
        Map<String, String> cacheSettings = aopCacheHelper.getSysLogsSettingStatusMap();
        if (BeanUtils.isEmpty(cacheSettings) || !cacheSettings.containsKey(MODULE_TYPE) || !LOGGER_ON.equals(cacheSettings.get(MODULE_TYPE))) {
            this.logger.error("\u672a\u83b7\u53d6\u5230\u65e5\u5fd7\u914d\u7f6e\u4e2d\u5173\u4e8e\u6a21\u5757\uff1a{}\u7684\u65e5\u5fd7\u914d\u7f6e\uff0c\u8df3\u8fc7\u8be5\u6a21\u5757\u7684\u65e5\u5fd7\u8bb0\u5f55\u3002", (Object)MODULE_TYPE);
            return false;
        }
        return true;
    }
}

