/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.sqlbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.AbstractSqlBuilder;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;

public class KingbaseesSqlBuilder
extends AbstractSqlBuilder {
    @Override
    public String analyzeResultField() {
        StringBuffer sql = new StringBuffer();
        ArrayNode resultField = this.sqlBuilderModel.getResultField();
        if (resultField == null || resultField.size() == 0) {
            sql.append("* ");
        } else {
            for (int i = 0; i < resultField.size(); ++i) {
                JsonNode jo = resultField.get(i);
                String field = jo.get("field").asText();
                String aggFuncOp = jo.get("AggFuncOp").asText();
                sql.append(aggFuncOp);
                sql.append("(" + field + ") ");
                String regex = ".*[A-Z]+.*";
                boolean result = field.matches(regex);
                if (result) {
                    field = "\"" + field + "\"";
                }
                if (!StringUtil.isEmpty(field)) {
                    sql.append(" as " + field + " ");
                }
                if (i >= resultField.size() - 1) continue;
                sql.append(",");
            }
        }
        return sql.toString();
    }

    @Override
    public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
        if (op == QueryOP.BETWEEN) {
            ObjectNode value1 = (ObjectNode)value;
            String start = JsonUtil.getString((JsonNode)value1, "start", "");
            String end = JsonUtil.getString((JsonNode)value1, "end", "");
            if (StringUtil.isNotEmpty(start)) {
                sql.append(" and " + field + " >= '" + start + "'");
            }
            if (StringUtil.isNotEmpty(end)) {
                sql.append(" and " + field + " <= '" + end + "'");
            }
        } else {
            sql.append(" and " + field + " " + op.op() + " '" + value.toString() + "'");
        }
    }
}

