/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.sqlbuilder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.query.QueryOP;
import com.hotent.base.sqlbuilder.AbstractSqlBuilder;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import java.text.ParseException;

public class OracleSqlBuilder
extends AbstractSqlBuilder {
    @Override
    public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
        String parseFormat = "yyyy-MM-dd HH:mm:ss";
        if (StringUtil.isEmpty(format)) {
            format = "yyyy-mm-dd hh24:mi:ss";
        } else {
            parseFormat = format;
            format = this.convertOracleFormat(format);
        }
        if (op == QueryOP.BETWEEN) {
            ObjectNode value1 = (ObjectNode)value;
            String start = JsonUtil.getString((JsonNode)value1, "start", "");
            String end = JsonUtil.getString((JsonNode)value1, "end", "");
            String newStart = start;
            String newEnd = end;
            try {
                newStart = DateFormatUtil.format(DateFormatUtil.parseDate(start, parseFormat).getTime(), parseFormat);
                newEnd = DateFormatUtil.format(DateFormatUtil.parseDate(newEnd, parseFormat).getTime(), parseFormat);
            }
            catch (ParseException e) {
                newStart = start;
            }
            if (StringUtil.isNotEmpty(newStart)) {
                sql.append(" and " + field + " >= to_date('" + newStart + "','" + format + "')");
            }
            if (StringUtil.isNotEmpty(newEnd)) {
                sql.append(" and " + field + " <= to_date('" + newEnd + "','" + format + "')");
            }
        } else {
            Object newValue = value;
            try {
                newValue = DateFormatUtil.format(DateFormatUtil.parseDate(value.toString(), parseFormat).getTime(), parseFormat);
            }
            catch (ParseException e) {
                newValue = value;
            }
            sql.append(" and " + field + " " + op.op() + " to_date('" + newValue.toString() + "','" + format + "')");
        }
    }

    private String convertOracleFormat(String format) {
        if ("yyyy-MM-dd HH:mm:ss".equals(format)) {
            return "yyyy-mm-dd hh24:mi:ss";
        }
        return "yyyy-mm-dd";
    }
}

