/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.tenant.impl;

import com.google.common.base.Joiner;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.tenant.AbstractTenantInitHandler;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TenantSysColumnHandler
extends AbstractTenantInitHandler {
    @Resource
    DatabaseContext databaseContext;

    @Override
    protected String getSql() {
        return String.format("select * from %s where tenant_id_ = '%s' and is_init_ = 1", this.tableName(), "-1");
    }

    @Override
    public String tableName() {
        return "portal_sys_column";
    }

    @Override
    public void handle(String tenantId) {
        List queryForList = this.jdbcTemplate.queryForList(this.getSql());
        ArrayList<String> updateSqls = new ArrayList<String>();
        for (Map map : queryForList) {
            String updateSql;
            Iterator iter = map.entrySet().iterator();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            Object id = null;
            int longtextIndex = -1;
            while (iter.hasNext()) {
                String lowerCase;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                switch (lowerCase = key.toLowerCase()) {
                    case "id_": 
                    case "id": {
                        value = UniqueIdUtil.getSuid();
                        id = value;
                        break;
                    }
                    case "tenant_id_": 
                    case "job_group": {
                        value = tenantId;
                        break;
                    }
                    case "path_": {
                        value = String.valueOf(value).split("\\.")[0] + "." + id + ".";
                        break;
                    }
                }
                if (!BeanUtils.isNotEmpty(value) || value instanceof Date || value instanceof LocalDateTime) continue;
                fields.add(key);
                if (value instanceof String) {
                    value = "'" + value + "'";
                }
                if (value instanceof byte[]) {
                    value = "?";
                }
                params.add(value);
                if (value.toString().length() <= 4000) continue;
                longtextIndex = params.size() - 1;
            }
            if (longtextIndex > -1) {
                int subNum = 3000;
                String templateHtml = params.get(longtextIndex).toString();
                params.set(longtextIndex, params.get(longtextIndex).toString().substring(0, subNum) + "'");
                updateSql = String.format("insert into %s(%s) values(%s)", this.tableName(), Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
                updateSqls.add(updateSql);
                int subIndex = (templateHtml.length() - subNum) / subNum + 1;
                for (int i = 1; i <= subIndex; ++i) {
                    int subLength = subNum * (i + 1);
                    if (i == subIndex) {
                        subLength = templateHtml.length() - 1;
                    }
                    String dhUpdateSql = "oracle".equals(this.databaseContext.getDbType()) || "dm".equals(this.databaseContext.getDbType()) ? String.format("update portal_sys_column set TEMPLATE_HTML = to_clob(TEMPLATE_HTML) || %s where ID = %s", "to_clob('" + templateHtml.substring(subNum * i, subLength) + "')", params.get(0)) : String.format("update portal_sys_column set TEMPLATE_HTML = concat(TEMPLATE_HTML,%s) where ID = %s", "'" + templateHtml.substring(subNum * i, subLength).replace("'", "''") + "'", params.get(0));
                    updateSqls.add(dhUpdateSql);
                }
                continue;
            }
            updateSql = String.format("insert into %s(%s) values(%s)", this.tableName(), Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
            updateSqls.add(updateSql);
        }
        for (String insertSql : updateSqls) {
            this.jdbcTemplate.update(insertSql);
        }
    }
}

