/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.tenant.impl;

import com.google.common.base.Joiner;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.tenant.AbstractTenantInitHandler;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TenantSysLayoutHandler
extends AbstractTenantInitHandler {
    @Resource
    DatabaseContext databaseContext;

    @Override
    protected String getSql() {
        return String.format("select * from %s where tenant_id_ = '%s' and is_def = 1", this.tableName(), "-1");
    }

    @Override
    public String tableName() {
        return "portal_sys_layout_manage";
    }

    @Override
    public void handle(String tenantId) {
        List queryForList = this.jdbcTemplate.queryForList(this.getSql());
        ArrayList<String> updateSqls = new ArrayList<String>();
        for (Map map : queryForList) {
            Iterator iter = map.entrySet().iterator();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            Object id = null;
            while (iter.hasNext()) {
                String lowerCase;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                switch (lowerCase = key.toLowerCase()) {
                    case "id": {
                        value = UniqueIdUtil.getSuid();
                        id = value;
                        break;
                    }
                    case "tenant_id_": {
                        value = tenantId;
                        break;
                    }
                    case "path_": {
                        value = String.valueOf(value).split("\\.")[0] + "." + id + ".";
                        break;
                    }
                }
                if (!BeanUtils.isNotEmpty(value) || value instanceof Date || value instanceof LocalDateTime) continue;
                fields.add(key);
                if (value instanceof String) {
                    value = "'" + value + "'";
                }
                if (value instanceof byte[]) {
                    value = "?";
                }
                params.add(value);
            }
            String updateSql = "";
            boolean outOfLimit = false;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i).toString().length() <= 4000 || !"DESIGN_HTML".equalsIgnoreCase((String)fields.get(i))) continue;
                outOfLimit = true;
                int subNum = 3000;
                String designHtml = "";
                designHtml = params.get(i).toString();
                params.set(i, params.get(i).toString().substring(0, subNum) + "'");
                updateSql = String.format("insert into %s(%s) values(%s)", this.tableName(), Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
                updateSqls.add(updateSql);
                int subIndex = (designHtml.length() - subNum) / subNum + 1;
                for (int j = 1; j <= subIndex; ++j) {
                    int subLength = subNum * (j + 1);
                    if (j == subIndex) {
                        subLength = designHtml.length() - 1;
                    }
                    String dhUpdateSql = "";
                    dhUpdateSql = "oracle".equals(this.databaseContext.getDbType()) || "dm".equals(this.databaseContext.getDbType()) ? String.format("update portal_sys_layout_manage set DESIGN_HTML = to_char(DESIGN_HTML) || %s where ID = %s", "to_char('" + designHtml.substring(subNum * j, subLength) + "')", params.get(0)) : String.format("update portal_sys_layout_manage set DESIGN_HTML = concat(DESIGN_HTML,%s) where ID = %s", "'" + designHtml.substring(subNum * j, subLength).replace("'", "''") + "'", params.get(0));
                    updateSqls.add(dhUpdateSql);
                }
                break;
            }
            if (outOfLimit) continue;
            updateSql = String.format("insert into %s(%s) values(%s)", this.tableName(), Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
            updateSqls.add(updateSql);
        }
        for (String insertSql : updateSqls) {
            this.jdbcTemplate.update(insertSql);
        }
    }
}

