/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.ExtendClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class AppUtil
implements ApplicationContextAware {
    private static String serverPort;
    @Value(value="${server.port}")
    public String applicationPort;
    protected static final Logger LOGGER;
    private static ApplicationContext context;

    @PostConstruct
    public void setPort() {
        serverPort = this.applicationPort;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public void setApplicationContext(ApplicationContext _context) throws BeansException {
        context = _context;
    }

    public static ApplicationContext getApplicaitonContext() {
        return context;
    }

    public static Object getBean(String beanId) {
        try {
            return context.getBean(beanId);
        }
        catch (Exception ex) {
            LOGGER.debug("getBean:" + beanId + "," + ex.getMessage());
            return null;
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return context.getBeansOfType(type);
    }

    public static <T> T getBean(Class<T> beanClass) {
        Object bean = null;
        try {
            bean = context.getBean(beanClass);
        }
        catch (Exception ex) {
            try {
                if (beanClass != null) {
                    String beanName = beanClass.getSimpleName();
                    String beanId = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
                    bean = context.getBean(beanId);
                }
            }
            catch (BeansException e) {
                LOGGER.debug("getBean:" + beanClass + "," + ex.getMessage());
            }
        }
        return (T)bean;
    }

    public static List<Class> getImplClass(Class clazz) throws Exception {
        ArrayList<Class> list = new ArrayList<Class>();
        Map map = context.getBeansOfType(clazz);
        for (Object obj : map.values()) {
            String name = obj.getClass().getName();
            int pos = name.indexOf("$$");
            if (pos > 0) {
                name = name.substring(0, name.indexOf("$$"));
            }
            Class cls = AppUtil.forName(name);
            list.add(cls);
        }
        return list;
    }

    public static Class forName(String className) throws Exception {
        Class cls;
        block2: {
            cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (Exception e) {
                cls = ExtendClassLoader.getClassByName(className);
                if (cls != null) break block2;
                throw e;
            }
        }
        return cls;
    }

    public static Map<String, Object> getImplInstance(Class clazz) throws ClassNotFoundException {
        Map map = context.getBeansOfType(clazz);
        return map;
    }

    public static void publishEvent(ApplicationEvent event) {
        if (context != null) {
            context.publishEvent(event);
        }
    }

    public static void publishEvent(Object var) {
        if (context != null) {
            context.publishEvent(var);
        }
    }

    public static String getClasspath() {
        String classPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        String rootPath = "";
        if ("\\".equals(File.separator)) {
            rootPath = classPath.substring(1);
            rootPath = rootPath.replace("/", "\\");
        }
        if ("/".equals(File.separator)) {
            rootPath = classPath.substring(1);
            rootPath = rootPath.replace("\\", "/");
        }
        return rootPath;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AppUtil.class);
    }
}

