/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.function.DesensitizationFunction;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.DesensitizeRegexUtil;
import com.hotent.base.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DesensitizeUtil {
    private static final String REPLACE = "*";

    public static Object IF(boolean arg, Object thenValue, Object otherwiseValue) {
        return arg ? thenValue : otherwiseValue;
    }

    public static boolean IS_EMPTY(Object target) {
        return BeanUtils.isEmpty(target);
    }

    public static Object LOWER(Object target) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return target;
        }
        String s = String.valueOf(target);
        return s.toLowerCase();
    }

    public static Object UPPER(Object target) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return target;
        }
        String s = String.valueOf(target);
        return s.toUpperCase();
    }

    public static String HEAD_RES(Object target, int headLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        return DesensitizeUtil.HEAD_RES(target, headLen, 0);
    }

    public static String HEAD_RES(Object target, int headLen, int minLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        String s = String.valueOf(target);
        if (s.length() <= headLen || s.length() <= minLen) {
            return s;
        }
        String headStr = s.substring(0, headLen);
        return headStr + StringUtil.nCopies(REPLACE, s.length() - headLen);
    }

    public static String HEAD_DES(Object target, int desLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        Object anIf = DesensitizeUtil.IF(DesensitizeUtil.LEN(target) > desLen, DesensitizeUtil.LEN(target) - desLen, DesensitizeUtil.LEN(target));
        return DesensitizeUtil.TAIL_RES(target, (Integer)anIf);
    }

    public static String TAIL_DES(Object target, int headLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        Object anIf = DesensitizeUtil.IF(DesensitizeUtil.LEN(target) > headLen, DesensitizeUtil.LEN(target) - headLen, DesensitizeUtil.LEN(target));
        return DesensitizeUtil.HEAD_RES(target, (Integer)anIf);
    }

    public static String HEAD_TAIL_DES(Object target, int leftLen, int rightLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        return DesensitizeUtil.TAIL_DES(DesensitizeUtil.HEAD_DES(target, leftLen), rightLen);
    }

    public static String LOOP_DES(Object target, String loopSymbol, String skipSymbols, DesensitizationFunction<String> formula) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        return DesensitizeUtil.loopDesensitize(target, loopSymbol, skipSymbols, formula);
    }

    public static String loopDesensitize(Object target, String loopSymbol, String skipSymbols, DesensitizationFunction<String> formula) {
        if (BeanUtils.isEmpty(target)) {
            return "";
        }
        HashSet<String> skipSymbolSet = new HashSet<String>();
        String[] skipSymbolsArray = skipSymbols.split(loopSymbol);
        Arrays.asList(skipSymbolsArray).forEach(e -> skipSymbolSet.add(e.trim()));
        CharSequence[] parts = target.toString().split(loopSymbol);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Symbol symbol = DesensitizeUtil.matchSymbol(skipSymbolSet, part);
            int index = symbol.index;
            if (index == -1) {
                parts[i] = formula.apply(part);
                continue;
            }
            int symbolLen = symbol.symbol.length();
            boolean beginEnd = index == 0 || index + symbolLen == part.length();
            String start = beginEnd ? formula.apply(part.substring(0, index)) : formula.apply(part).substring(0, index);
            String end = beginEnd ? formula.apply(part.substring(index + symbolLen)) : formula.apply(part).substring(index + symbolLen);
            parts[i] = String.format("%s%s%s", start, symbol.symbol, end);
        }
        return String.join((CharSequence)loopSymbol, parts);
    }

    public static Symbol matchSymbol(Set<String> skipSymbolSet, String pattern) {
        if (BeanUtils.isEmpty(skipSymbolSet) || StringUtil.isEmpty(pattern)) {
            return new Symbol(-1);
        }
        Symbol symbol = new Symbol(-1);
        for (String skipSymbol : skipSymbolSet) {
            int index = pattern.indexOf(skipSymbol);
            if (index == -1) continue;
            return new Symbol(index, skipSymbol);
        }
        return symbol;
    }

    public static String TAIL_RES(Object target, int tailLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        return DesensitizeUtil.TAIL_RES(target, tailLen, 0);
    }

    public static String TAIL_RES(Object target, int tailLen, int minLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        String s = String.valueOf(target);
        if (s.length() <= tailLen || s.length() <= minLen) {
            return s;
        }
        String tailStr = s.substring(s.length() - tailLen);
        return StringUtil.nCopies(REPLACE, s.length() - tailLen) + tailStr;
    }

    public static String HEAD_TAIL_RES(Object target, int headLen, int tailLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        return DesensitizeUtil.HEAD_TAIL_RES(target, headLen, tailLen, 0);
    }

    public static String HEAD_TAIL_RES(Object target, int headLen, int tailLen, int minLen) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        String s = String.valueOf(target);
        if (s.length() <= headLen || s.length() <= tailLen || s.length() <= headLen + tailLen || s.length() <= minLen) {
            return s;
        }
        String headStr = s.substring(0, headLen);
        String tailStr = s.substring(s.length() - tailLen);
        return headStr + StringUtil.nCopies(REPLACE, s.length() - headLen - tailLen) + tailStr;
    }

    public static int LEN(Object target) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return 0;
        }
        return String.valueOf(target).length();
    }

    public static int INDEX_OF(Object target, String str) {
        if (target == null) {
            target = "";
        }
        return String.valueOf(target).indexOf(str);
    }

    public static String SLICE(Object target, int interval) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        if (interval == 0) {
            return String.valueOf(target);
        }
        StringBuffer sb = new StringBuffer("");
        String s = String.valueOf(target);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i / interval % 2 == 0) {
                sb.append(c);
                continue;
            }
            sb.append(REPLACE);
        }
        return sb.toString();
    }

    public static String SUBSTRING(Object target, int beginIndex) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        String s = String.valueOf(target);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex > s.length()) {
            beginIndex = s.length();
        }
        return s.substring(beginIndex);
    }

    public static String SUBSTRING(Object target, int beginIndex, int endIndex) {
        if (DesensitizeUtil.IS_EMPTY(target)) {
            return "";
        }
        String s = String.valueOf(target);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex > s.length()) {
            beginIndex = s.length();
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex > s.length()) {
            endIndex = s.length();
        }
        return s.substring(beginIndex, endIndex);
    }

    public static String FILL_HEAD(Object target, int threshold) {
        String s;
        if (DesensitizeUtil.IS_EMPTY(target)) {
            target = "";
        }
        if (threshold < 0) {
            threshold = 0;
        }
        if ((s = String.valueOf(target)).length() >= threshold) {
            return s;
        }
        return StringUtil.nCopies(REPLACE, threshold - s.length()) + s;
    }

    public static String FILL_TAIL(Object target, int threshold) {
        String s;
        if (DesensitizeUtil.IS_EMPTY(target)) {
            target = "";
        }
        if (threshold < 0) {
            threshold = 0;
        }
        if ((s = String.valueOf(target)).length() >= threshold) {
            return s;
        }
        return s + StringUtil.nCopies(REPLACE, threshold - s.length());
    }

    public static String REGEX(Object target) {
        return DesensitizeRegexUtil.regexDesensitizeSensitive(target);
    }

    public static String REGEX(Object target, boolean desensitizeAddress) {
        return DesensitizeRegexUtil.regexDesensitizeSensitive(target, desensitizeAddress);
    }

    public static String CUSTOM_REGEX(Object target, DesensitizationFunction<String> function, String ... regex) {
        return DesensitizeRegexUtil.customDesensitize(DesensitizeUtil.IS_EMPTY(target) ? "" : target.toString(), function, regex);
    }

    public static String CUSTOM_REGEX(Object target, Map<String, DesensitizationFunction<String>> functionMap) {
        return DesensitizeRegexUtil.customDesensitize(DesensitizeUtil.IS_EMPTY(target) ? "" : target.toString(), functionMap);
    }

    public static void main(String[] args) {
        System.out.println(DesensitizeUtil.HEAD_DES("\u767e\u9a91\u52ab\u9b4f\u8425\uff0c\u529f\u9707\u5929\u4e0b\u82f1", 3));
        System.out.println(DesensitizeUtil.TAIL_DES("\u767e\u9a91\u52ab\u9b4f\u8425\uff0c\u529f\u9707\u5929\u4e0b\u82f1", 3));
        System.out.println(DesensitizeUtil.HEAD_TAIL_DES("\u767e\u9a91\u52ab\u9b4f\u8425\uff0c\u529f\u9707\u5929\u4e0b\u82f1", 3, 3));
        String input = "\u59d3\u540d\uff1a\u897f\u95e8\u98de\u96ea\u767e\u9a91\u52ab\u9b4f\u8425\uff0c\u674e\u706b\u65fa\u5148\u751f\uff0c\u738b\u4f73\u6021\u5973\u58eb";
        System.out.println(DesensitizeUtil.LOOP_DES(input, "\uff0c", "\u59d3\u540d\uff1a\uff0c\u5148\u751f\uff0c\u5973\u58eb", value -> DesensitizeUtil.TAIL_RES(value, 2)));
        String inputs = "\u59d3\u540d\uff1a\u5f20\u4e09\uff0c\u5361\u53f7\uff1a622202199012345678\uff0c\u624b\u673a\u53f7\uff1a13800138000\uff0c\u8bc1\u4ef6\u53f7\uff1a110101199001012345";
        String inputss = "\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u6d77\u73e0\u533a,\u9ec4xx\u5148\u751f622202199012345678,362000199009191560\u5b8f\u5929\u8f6f\u4ef6\u80a1\u4efd\u6709\u9650\u516c\u53f813479315954";
        String content = "\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u6d77\u73e0\u533a\uff1f:\u7ae0\u9c7c\u5148\u751f6225561653166630,362330199912051750\u5b8f\u5929\u8f6f\u4ef6\u80a1\u4efd\u6709\u9650\u516c\u53f813471215954\u5180DSX888G12345678 010-12345619";
        String contents = "\u5730\u5740\uff1a\u5e7f\u4e1c\u7701\u6d77\u73e0\u533a\u7436\u6d32\u5927\u9053\uff0c\u59d3\u540d\uff1a\u5f20\u4e09\u4e30\u5148\u751f\uff0c\u5361\u53f7\uff1a666666666666666\uff0c\u8eab\u4efd\u8bc1\u53f7\uff1a440304198704208888, \u8054\u7cfb\u7535\u8bdd\uff1a18888888888\uff0c\u8f66\u724c\u53f7\uff1a\u7ca4B88888";
        System.out.println(DesensitizeUtil.REGEX(contents, true));
        System.out.println(DesensitizeUtil.CUSTOM_REGEX(contents, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 2, 2), "\\d{16,19}", "[\\u4e00-\\u9fa5]{1}[A-Z]{1}[A-Z0-9]{5}"));
    }

    public static class Symbol {
        int index;
        String symbol;

        public Symbol(int index) {
            this.index = index;
        }

        public Symbol(int index, String symbol) {
            this.index = index;
            this.symbol = symbol;
        }
    }
}

