/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.druid.proxy.jdbc.ClobProxyImpl;
import com.alibaba.druid.proxy.jdbc.NClobProxyImpl;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.hotent.base.exception.BaseException;
import com.hotent.base.jackson.ClobProxyImplSerializer;
import com.hotent.base.jackson.NClobProxyImplSerializer;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <C> C toBean(String json, Class<C> cls) throws JsonParseException, JsonMappingException, IOException {
        return (C)mapper.readValue(json, cls);
    }

    public static <C> C toBean(JsonNode jsonNode, Class<C> cls) throws JsonParseException, JsonMappingException, IOException {
        Assert.notNull((Object)jsonNode, (String)"jsonNode can not be empty.");
        return (C)mapper.convertValue((Object)jsonNode, cls);
    }

    public static JsonNode toJsonNode(Object obj) throws IOException {
        if (BeanUtils.isEmpty(obj)) {
            return null;
        }
        return (JsonNode)mapper.convertValue(obj, JsonNode.class);
    }

    public static JsonNode toJsonNode(String json) throws IOException {
        return mapper.readTree(json);
    }

    public static <C> C toBean(String json, TypeReference<C> typeRef) throws JsonParseException, JsonMappingException, IOException {
        Object list = mapper.readValue(json, typeRef);
        return (C)list;
    }

    public static <C> C toBean(JsonNode jsonNode, TypeReference<C> typeRef) throws IOException {
        Object list = mapper.convertValue((Object)jsonNode, typeRef);
        return (C)list;
    }

    public static String toJson(Object obj) throws IOException {
        return mapper.writeValueAsString(obj);
    }

    public static String toJsonIndent(Object obj) throws IOException {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(obj);
    }

    public static String toJsonString(Object obj) {
        if (obj != null && obj instanceof String) {
            return obj.toString();
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new BaseException("\u5c06\u5bf9\u8c61\u89e3\u6790\u4e3a\u5b57\u7b26\u4e32\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    public static <T> Map<String, T> toMap(String json) throws IOException {
        Map map = (Map)mapper.readValue(json, Map.class);
        return map;
    }

    public static String getString(JsonNode obj, String key, String defaultValue) {
        if (!JsonUtil.isContainsKey(obj, key)) {
            return defaultValue;
        }
        try {
            if (obj.get(key).isObject() || obj.get(key).isArray()) {
                return JsonUtil.toJson(obj.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonNode jsonNode = obj.get(key);
        if (jsonNode.isNull()) {
            return defaultValue;
        }
        return jsonNode.asText();
    }

    public static LocalDate getLocalDate(JsonNode obj, String key) {
        String result = JsonUtil.getString(obj, key, null);
        if (StringUtil.isEmpty(result)) {
            return null;
        }
        try {
            return LocalDateTimeUtil.parseDate((CharSequence)result);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static String getString(JsonNode obj, String key) {
        return JsonUtil.getString(obj, key, "");
    }

    public static int getInt(JsonNode obj, String key) {
        if (!JsonUtil.isContainsKey(obj, key)) {
            return 0;
        }
        return obj.get(key).asInt();
    }

    public static int getInt(JsonNode obj, String key, int defaultValue) {
        if (!JsonUtil.isContainsKey(obj, key)) {
            return defaultValue;
        }
        return obj.get(key).asInt();
    }

    public static boolean getBoolean(ObjectNode obj, String key) {
        if (!JsonUtil.isContainsKey((JsonNode)obj, key)) {
            return false;
        }
        return obj.get(key).asBoolean();
    }

    public static boolean getBoolean(ObjectNode obj, String key, boolean defaultValue) {
        if (!JsonUtil.isContainsKey((JsonNode)obj, key)) {
            return defaultValue;
        }
        return obj.get(key).asBoolean();
    }

    public static ArrayNode getArray(JsonNode node, String key, ArrayNode defaultValue) {
        if (!JsonUtil.isContainsKey(node, key)) {
            return defaultValue;
        }
        if (!node.get(key).isArray()) {
            throw new BaseException("\u8be5\u5c5e\u6027\u4e0b\u7684\u503c\u4e0d\u662f\u6570\u7ec4");
        }
        return (ArrayNode)node.get(key);
    }

    public static ArrayNode getArray(JsonNode node, String key) {
        return JsonUtil.getArray(node, key, JsonUtil.createArrayNode());
    }

    public static boolean isNotEmptyJsonArr(String jsonArrStr) {
        return !JsonUtil.isEmptyJsonArr(jsonArrStr);
    }

    public static boolean isEmptyJsonArr(String jsonArrStr) {
        if (StringUtil.isEmpty(jsonArrStr)) {
            return true;
        }
        try {
            ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode(jsonArrStr);
            return jsonAry.size() <= 0;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return true;
        }
    }

    public static boolean isContainsKey(JsonNode obj, String key) {
        if (obj != null && key != null) {
            Iterator iterator = obj.fieldNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (!key.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static String escapeSpecialChar(String str) {
        StringBuffer sb = new StringBuffer();
        block10: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void removeNull(ObjectNode jsonObject) {
        Iterator newSet = jsonObject.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            JsonNode val = jsonObject.get((String)ent.getKey());
            if (!(val instanceof NullNode)) continue;
            jsonObject.put((String)ent.getKey(), "");
        }
    }

    public static void removeNull(ArrayNode jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonUtil.removeNull((ObjectNode)jsonArray.get(i));
        }
    }

    public static ObjectNode arrayToObject(ArrayNode jsonArray, String keyName) throws IOException {
        ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
        for (int i = 0; i < jsonArray.size(); ++i) {
            ArrayNode children;
            JsonNode temp = JsonUtil.toJsonNode(jsonArray.get(i));
            Objects.requireNonNull(temp);
            if (temp.has(keyName)) {
                jsonObject.put(temp.get(keyName).asText(), temp);
            }
            if (!temp.has("children") || (children = JsonUtil.getArray(temp, "children")) == null || children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JsonNode tempChild = JsonUtil.toJsonNode(children.get(j));
                if (tempChild == null || !tempChild.has(keyName)) continue;
                jsonObject.put(tempChild.get(keyName).asText(), tempChild);
            }
        }
        return jsonObject;
    }

    public static ArrayNode objectToArray(JsonNode jsonObject) {
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        Iterator newSet = jsonObject.fields();
        while (newSet.hasNext()) {
            Map.Entry ent = (Map.Entry)newSet.next();
            jsonArray.add(jsonObject.get((String)ent.getKey()));
        }
        return jsonArray;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof ObjectNode) {
            return ((ObjectNode)obj).isObject();
        }
        if (obj instanceof ArrayNode) {
            return ((ArrayNode)obj).isArray();
        }
        return NullNode.getInstance().equals(obj);
    }

    public static List<ObjectNode> arrayToList(ArrayNode jsonArray) throws IOException {
        ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonNode temp = JsonUtil.toJsonNode(jsonArray.get(i));
            list.add((ObjectNode)temp);
        }
        return list;
    }

    public static <T> ArrayNode listToArrayNode(List<T> list) throws IOException {
        if (BeanUtils.isEmpty(list)) {
            return null;
        }
        ArrayNode aryNode = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isNotEmpty(list)) {
            for (T uv : list) {
                aryNode.add(JsonUtil.toJsonNode(uv));
            }
        }
        return aryNode;
    }

    public static <T> List<ObjectNode> listToListNode(List<T> list) throws IOException {
        if (BeanUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<ObjectNode> nodeList = new ArrayList<ObjectNode>();
        if (BeanUtils.isNotEmpty(list)) {
            for (T uv : list) {
                nodeList.add((ObjectNode)JsonUtil.toJsonNode(uv));
            }
        }
        return nodeList;
    }

    public static String clearJsonStrBackslash(String jsonStr) throws IOException {
        if (StringUtil.isEmpty(jsonStr)) {
            return "";
        }
        JsonNode jsonNode = JsonUtil.toJsonNode(jsonStr);
        if (jsonNode instanceof TextNode) {
            return jsonNode.asText();
        }
        return JsonUtil.toJson(jsonNode);
    }

    public static void putObjectToJson(ObjectNode obj, String filedName, Object value) {
        if (BeanUtils.isEmpty(value) || BeanUtils.isEmpty(obj) || StringUtil.isEmpty(filedName)) {
            return;
        }
        if (value instanceof String) {
            obj.put(filedName, (String)value);
        } else if (value instanceof Integer) {
            obj.put(filedName, ((Integer)value).intValue());
        } else if (value instanceof Double) {
            obj.put(filedName, (Double)value);
        } else if (value instanceof Float) {
            obj.put(filedName, (Float)value);
        } else if (value instanceof Long) {
            obj.put(filedName, (Long)value);
        } else if (value instanceof Boolean) {
            obj.put(filedName, (Boolean)value);
        } else if (value instanceof LocalDateTime) {
            obj.put(filedName, TimeUtil.getDateTimeString((LocalDateTime)value));
        } else if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            obj.put(filedName, TimeUtil.getDateString(date.atTime(0, 0)));
        }
    }

    public static JsonNode getByPath(JsonNode obj, String path) {
        Assert.notNull((Object)path, (String)"\u8981\u83b7\u53d6\u5bf9\u8c61\u7684path\u4e0d\u80fd\u4e3a\u7a7a!");
        if (BeanUtils.isEmpty(obj)) {
            return null;
        }
        Object[] pathList = path.split("\\.");
        if (pathList.length > 1) {
            if (BeanUtils.isNotEmpty(obj.get(pathList[0]))) {
                return JsonUtil.getByPath(obj.get(pathList[0]), StringUtils.join((Object[])ArrayUtils.remove((Object[])pathList, (int)0), (String)"."));
            }
            return null;
        }
        return obj.get(path);
    }

    public static String getStrByPath(JsonNode obj, String path) {
        return JsonUtil.getStrByPath(obj, path, Objects::requireNonNull);
    }

    public static String getStrByPath(JsonNode obj, String path, Consumer<JsonNode> consumer) {
        JsonNode jsonNode = JsonUtil.getByPath(obj, path);
        consumer.accept(jsonNode);
        if (BeanUtils.isNotEmpty(jsonNode) && jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return "";
    }

    public static JsonNode getIgnoreCase(JsonNode obj, String key) {
        if (BeanUtils.isEmpty(obj) || StringUtil.isEmpty(key)) {
            return null;
        }
        Iterator iterator = obj.fields();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (!((String)next.getKey()).equalsIgnoreCase(key)) continue;
            return (JsonNode)next.getValue();
        }
        return null;
    }

    public static String getStringIgnoreKey(JsonNode obj, String key, String defalutVal) {
        JsonNode jsonNode = JsonUtil.getIgnoreCase(obj, key);
        if (BeanUtils.isNotEmpty(jsonNode) && jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        return defalutVal;
    }

    public static ObjectNode createObjectNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return mapper.createArrayNode();
    }

    public static List toList(String content, Class classType) {
        List dataList = null;
        try {
            dataList = (List)mapper.readValue(content, mapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{classType}));
        }
        catch (JsonProcessingException e) {
            throw new BaseException("\u5b57\u7b26\u4e32\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return dataList;
    }

    public static Map<String, JsonNode> getMatchingFields(JsonNode jsonNode, String prefix) {
        LinkedHashMap<String, JsonNode> matchingFields = new LinkedHashMap<String, JsonNode>();
        if (jsonNode == null || StringUtil.isEmpty(prefix)) {
            return matchingFields;
        }
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry map = (Map.Entry)fields.next();
            if (!StringUtil.isNotEmpty((String)map.getKey()) || !((String)map.getKey()).startsWith(prefix)) continue;
            matchingFields.put((String)map.getKey(), (JsonNode)map.getValue());
        }
        return matchingFields;
    }

    public static JsonNode emptyAll(JsonNode node) {
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            JsonNode value = (JsonNode)entry.getValue();
            if (!value.isTextual()) continue;
            ((ObjectNode)node).put((String)entry.getKey(), "");
        }
        return node;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleDateFormat myDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormat));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormat));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormat));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormat));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormat));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormat));
        mapper.registerModule((Module)javaTimeModule);
        mapper.setDateFormat((DateFormat)myDateFormat);
        SimpleModule sm = new SimpleModule();
        sm.addSerializer(NClobProxyImpl.class, (JsonSerializer)new NClobProxyImplSerializer());
        sm.addSerializer(ClobProxyImpl.class, (JsonSerializer)new ClobProxyImplSerializer());
        mapper.registerModule((Module)sm);
    }
}

