/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MapUtil {
    public static <T> T getIgnoreCase(Map<String, T> map, String key, T defaultVal) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(key), (String)"\u83b7\u53d6Map\u4e2d\u6307\u5b9akey\u7684\u503c\u65f6key\u4e0d\u80fd\u4e3a\u7a7a");
        for (String k : map.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            return map.get(k);
        }
        return defaultVal;
    }

    public static boolean containsIgnoreKey(Map<String, Object> map, String key) {
        for (String k : map.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getIgnoreCase(Map<String, T> map, String key) {
        return MapUtil.getIgnoreCase(map, key, null);
    }

    public static Map<String, Object> buildMap(String key, Object val) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, val);
        return map;
    }

    public static String getString(Map<String, Object> map, String key) {
        return MapUtil.getString(map, key, null);
    }

    public static String getString(Map<String, Object> map, String key, String defaultVal) {
        Object object = map.get(key);
        if (object == null) {
            return defaultVal;
        }
        return object.toString();
    }

    public static int getInt(Map<String, Object> map, String key, int defaultValue) {
        Object object = map.get(key);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof BigDecimal) {
            BigDecimal object1 = (BigDecimal)object;
            return object1.intValue();
        }
        return (Integer)object;
    }

    public static String getStringIgnoreKey(Map<String, Object> map, String key, String defaultVal) {
        String valObj = MapUtil.getIgnoreCase(map, key, defaultVal);
        if (valObj != null) {
            if (valObj instanceof Date) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return dateFormat.format(valObj);
            }
            if (valObj instanceof LocalDateTime) {
                return TimeUtil.getDateTimeString((LocalDateTime)((Object)valObj));
            }
            return valObj.toString();
        }
        return defaultVal;
    }

    public static <T> void delByStartKey(Map<String, T> map, String key) {
        if (key == null) {
            map.remove(null);
            return;
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String k = iterator.next();
            if (!StringUtil.isNotEmpty(k) || !k.startsWith(key)) continue;
            iterator.remove();
            map.remove(k);
        }
    }

    public static Map<String, Object> toReplaceKeyLow(Map<String, Object> map) {
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                key = "IS_DELE_".equalsIgnoreCase(key) ? "isDelete" : StringUtil.underlineToHump(key);
                reMap.put(key, map.get(entry.getKey()));
            }
        }
        return reMap;
    }

    public static <K, T> Map<K, List<T>> toMapList(List<T> list, Function<T, K> keyFunction, int size) {
        HashMap result = new HashMap();
        if (BeanUtils.isEmpty(list)) {
            return result;
        }
        for (T t : list) {
            List mapList;
            K key = keyFunction.apply(t);
            if (key == null) continue;
            if (!result.containsKey(key)) {
                result.put(key, new LinkedList());
            }
            if ((mapList = (List)result.get(key)).size() >= size) continue;
            mapList.add(t);
        }
        return result;
    }
}

