/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RSAUtil {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCMnhQ99yP-eEU2jXdQWc6j-wWbqNLqOLinEGBY11WJUCmzHiEycDXPc6-3YMOvrdAiHZcjkMCzU_eRnBLUqkcNw9nhQrCak-sTpEVlAV21LskD6KMf-6PsfttUvpXeCO5g3Hg48F_vbLKxb8s_lcvQgCpKBIpsUdYRcp_PgSg8BQIDAQAB";
    private static String privateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIyeFD33I_54RTaNd1BZzqP7BZuo0uo4uKcQYFjXVYlQKbMeITJwNc9zr7dgw6-t0CIdlyOQwLNT95GcEtSqRw3D2eFCsJqT6xOkRWUBXbUuyQPoox_7o-x-21S-ld4I7mDceDjwX-9ssrFvyz-Vy9CAKkoEimxR1hFyn8-BKDwFAgMBAAECgYBt4JAco2Mi0sPyjrQuux43EE0fhtnYX54aHTfL8-dItrT-24pBKWFCyzkA58HBIuZB4jFZfyC0f-Yxh21HdA60T8EAmHcJubIFOREeQdFbvTDBYuwcrQSmTsJ17yw_qB-DZrbSd0YvpAnJnu1rBhzrcrskQPmaxM4Jv-08aKj8gQJBAMnqpcSi3onhUUVDYnQLJWIGqRjkPdWTgd4-k0JhBwxwGrIMgzsOBS21i7BfSSrKyFRhs6tgMYA0DsfIavwcP5ECQQCySCxbpvaxr8hBKXc0Xy50w4_F1IBNWY47v4kZGEf-DA8LmwtuWb-5Jdnoss8ZFx6rGxD2uZKzHWIwWbIOGmM1AkB3fRuyHOvyzlro0TKvF3V86BIjf9Yz0MH2wjMlAgRI0QKLQSpbxTU9UoUiz5Cd-TjJ7rODhD5m7uecRLdDEHhxAkBkpCGGS6aPf-_H-SR1yBVtjMgooWEcSSXlzKYUKITbgOstXgUB8mAsoJV2qxoFy-tgJBNbdD7AJiI7sSa2l2bRAkEAhjzNzzGqhHnBYrExOtuU7UZlEK-d-2DTS_6b6stokpbZncKI7G65-yX6CILZ798wGI6rzhkzYg1_bcj6b5jptQ";
    @Value(value="${RSA.privateKey:}")
    private String priKey;

    @PostConstruct
    public void setPort() {
        if (StringUtil.isNotEmpty(this.priKey)) {
            privateKey = this.priKey;
        }
    }

    public static Map<String, String> createKeys(int keySize) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm-->[RSA]");
        }
        kpg.initialize(keySize);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64URLSafeString((byte[])publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64URLSafeString((byte[])privateKey.getEncoded());
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("publicKey", publicKeyStr);
        keyPairMap.put("privateKey", privateKeyStr);
        return keyPairMap;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), privateKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String Decrypt(String data) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (StringUtil.isEmail(data)) {
            return "";
        }
        return RSAUtil.privateDecrypt(data, RSAUtil.getPrivateKey(privateKey));
    }

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtil.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String publicDecrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, publicKey);
            return new String(RSAUtil.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), publicKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        byte[] resultDatas = new byte[10];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offSet = 0;
            int i = 0;
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
            resultDatas = out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        return resultDatas;
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keyMap = RSAUtil.createKeys(1024);
        String publicKey = keyMap.get("publicKey");
        String privateKey = keyMap.get("privateKey");
        System.out.println("\u516c\u94a5: \n\r" + publicKey);
        System.out.println("\u79c1\u94a5\uff1a \n\r" + privateKey);
        System.out.println("\u516c\u94a5\u52a0\u5bc6\u2014\u2014\u79c1\u94a5\u89e3\u5bc6");
        String str = "123456789";
        System.out.println("\r\u660e\u6587\uff1a\r\n" + str);
        System.out.println("\r\u660e\u6587\u5927\u5c0f\uff1a\r\n" + str.getBytes().length);
        String encodedData = RSAUtil.publicEncrypt(str, RSAUtil.getPublicKey(publicKey));
        System.out.println("\u5bc6\u6587\uff1a\r\n" + encodedData);
        String decodedData = RSAUtil.privateDecrypt(encodedData, RSAUtil.getPrivateKey(privateKey));
        System.out.println("\u89e3\u5bc6\u540e\u6587\u5b57: \r\n" + decodedData);
    }
}

