/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ResubmitLock {
    private static final ConcurrentHashMap<String, Object> LOCK_CACHE = new ConcurrentHashMap(500);
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadPoolExecutor.DiscardPolicy());

    private ResubmitLock() {
    }

    public static ResubmitLock getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public boolean lock(String key, Object value) {
        return Objects.isNull(LOCK_CACHE.putIfAbsent(key, value));
    }

    public void unLock(boolean lock, String key, int delaySeconds) {
        if (lock) {
            EXECUTOR.schedule(() -> LOCK_CACHE.remove(key), (long)delaySeconds, TimeUnit.SECONDS);
        }
    }

    private static class SingletonInstance {
        private static final ResubmitLock INSTANCE = new ResubmitLock();

        private SingletonInstance() {
        }
    }
}

