/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.exception.BaseException;
import com.hotent.base.security.CustomPwdEncoder;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class SecurityUtil {
    private static SessionRegistry sessionRegistry;

    public static Authentication login(HttpServletRequest request, String userName, String pwd, boolean isIgnorePwd) {
        AuthenticationManager authenticationManager = AppUtil.getBean(AuthenticationManager.class);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)userName, (Object)pwd);
        authRequest.setDetails((Object)new WebAuthenticationDetails(request));
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (isIgnorePwd) {
            PasswordEncoder passwordEncoder = AppUtil.getBean(PasswordEncoder.class);
            if (passwordEncoder instanceof CustomPwdEncoder) {
                CustomPwdEncoder customPwdEncoder = (CustomPwdEncoder)passwordEncoder;
                customPwdEncoder.setIngore(true);
            } else {
                throw new BaseException("PasswordEncoder can not support ignorePwd login.");
            }
        }
        Authentication auth = authenticationManager.authenticate((Authentication)authRequest);
        securityContext.setAuthentication(auth);
        return auth;
    }

    public static void kickoutUser(String account) {
        if (StringUtil.isEmpty(account)) {
            return;
        }
        if (sessionRegistry == null) {
            sessionRegistry = AppUtil.getBean(SessionRegistry.class);
        }
        List objects = sessionRegistry.getAllPrincipals();
        for (Object o : objects) {
            List sis;
            User user = (User)o;
            if (!account.equals(user.getUsername()) || (sis = sessionRegistry.getAllSessions(o, false)) == null) continue;
            for (SessionInformation si : sis) {
                si.expireNow();
            }
        }
    }
}

