/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.StringUtil;
import com.hotent.base.util.string.StringValidator;
import com.hotent.base.util.time.DateFormatUtil;

public class SqlDateFormatUtil {
    public static String convertDateFormat(String format, String value, String dbType) {
        if ("oracle".equals(dbType) || "dm".equals(dbType)) {
            return SqlDateFormatUtil.convertToOracle(format, value);
        }
        if ("mysql".equals(dbType)) {
            return SqlDateFormatUtil.convertToMySql(format, value);
        }
        if ("sqlserver".equals(dbType)) {
            return SqlDateFormatUtil.convertToMsSql(format, value);
        }
        return value;
    }

    private static String convertToOracle(String format, String value) {
        if (StringUtil.isEmpty(format)) {
            format = "yyyy-MM-dd";
        }
        format = format.replace("HH", "hh24");
        format = format.replace("mm", "mi");
        try {
            value = DateFormatUtil.dateStringToString(value, format);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return " TO_DATE('" + value + "','" + format + "')";
    }

    private static String convertToMySql(String format, String value) {
        if (StringValidator.isEmail(format)) {
            format = "%Y-%m-%d";
        }
        format = format.replace("yyyy", "%Y");
        format = format.replace("MM", "%m");
        format = format.replace("dd", "%d");
        format = format.replace("HH", "%H");
        format = format.replace("hh", "%h");
        format = format.replace("mm", "%i");
        format = format.replace("ss", "%s");
        String rtn = " STR_TO_DATE('" + value + "','" + format + "')";
        return rtn;
    }

    private static String convertToMsSql(String format, String value) {
        String rtn = " cast('" + value + "' as datetime) ";
        return rtn;
    }
}

