/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.stereotype.Service;

@Service
public class ThreadMethodUtil
implements ContextThread {
    private static ThreadLocal<Map<String, List<ObjectFactory<?>>>> localMapFactory = new ThreadLocal();
    public static final String POST_ASYNC = "post_async";
    public static final String SERVICE_LOG = "service_log";
    public static final String CALL_LOG = "call_log";
    public static final String COMPENSATION_INTERFACE = "compensation_interface";

    public static void addMapFactory(String key, List<ObjectFactory<?>> factoryList) {
        Map<String, List<ObjectFactory<?>>> map = localMapFactory.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap();
        }
        map.put(key, factoryList);
        localMapFactory.set(map);
    }

    public static List<ObjectFactory<?>> getMapFactory(String key) {
        Map<String, List<ObjectFactory<?>>> map = localMapFactory.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static List<ObjectFactory<?>> getMapFactory(String key, boolean clean) {
        Map<String, List<ObjectFactory<?>>> map = localMapFactory.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            List<ObjectFactory<?>> factoryList = map.get(key);
            if (clean) {
                map.remove(key);
            }
            return factoryList;
        }
        return null;
    }

    public static void cleanMapFactory() {
        localMapFactory.remove();
    }

    public static void deleteMapFactory(String key) {
        Map<String, List<ObjectFactory<?>>> map = localMapFactory.get();
        map.remove(key);
    }

    @Override
    public void cleanAll() {
        ThreadMethodUtil.cleanMapFactory();
    }
}

