/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ZipUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletResponse;

public class ZipFileUtil {
    public static final String TEMP_FOLDER = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/").replace("/", File.separator);

    public static void zipAndDownload(String zipName, Consumer<String> consumer, HttpServletResponse response) throws IOException {
        ZipFileUtil.createTempPath(zipName);
        consumer.accept(ZipFileUtil.getTempFolder(zipName));
        ZipFileUtil.zipAndDownload(zipName, response);
    }

    public static void zip(String zipName, Consumer<String> consumer) throws IOException {
        ZipFileUtil.createTempPath(zipName);
        consumer.accept(ZipFileUtil.getTempFolder(zipName));
        ZipFileUtil.zip(zipName);
    }

    public static void zip(String zipName, Map<String, byte[]> fileMap) throws IOException {
        ZipFileUtil.zip(zipName, (String name) -> {
            for (Map.Entry ent : fileMap.entrySet()) {
                String fileName = (String)ent.getKey();
                byte[] content = (byte[])ent.getValue();
                String filePath = name + File.separator + fileName;
                File file = new File(filePath);
                try {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])content);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void zipAndDownload(String zipName, Map<String, byte[]> fileMap, HttpServletResponse response) throws IOException {
        ZipFileUtil.zipAndDownload(zipName, (String name) -> {
            for (Map.Entry ent : fileMap.entrySet()) {
                String fileName = (String)ent.getKey();
                byte[] content = (byte[])ent.getValue();
                String filePath = name + File.separator + fileName;
                File file = new File(filePath);
                try {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])content);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, response);
    }

    public static void zipAndDownload(String zipName, HttpServletResponse response) throws IOException {
        String zipPath = TEMP_FOLDER + File.separator + zipName;
        ZipUtil.zip((String)zipPath);
        FileUtil.deleteDir(new File(zipPath));
        HttpUtil.downLoadFile(response, zipPath + ".zip", zipName + ".zip");
        FileUtil.deleteFile(zipPath + ".zip");
    }

    public static void zip(String zipName) throws IOException {
        String zipPath = TEMP_FOLDER + File.separator + zipName;
        ZipUtil.zip((String)zipPath);
        FileUtil.deleteDir(new File(zipPath));
    }

    private static void createTempPath(String zipName) {
        String folderPath = ZipFileUtil.getTempFolder(zipName) + File.separator;
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private static String getTempFolder(String zipName) {
        return TEMP_FOLDER + zipName;
    }
}

