/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ThreadMethodUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InterfaceEventPostAsyncAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String POST_ASYNC_POINT = "@annotation(com.hotent.base.annotation.InterfaceEventPostAsync)";

    @AfterReturning(value="@annotation(com.hotent.base.annotation.InterfaceEventPostAsync)", returning="object")
    public void doAfterReturningAdvice1(Object object) throws Exception {
        if (object == null) {
            this.executeJob();
        }
        CommonResult result = null;
        if (object instanceof CommonResult) {
            result = (CommonResult)object;
        }
        if (object instanceof CompletableFuture) {
            result = (CommonResult)((CompletableFuture)object).get();
        }
        if (BeanUtils.isNotEmpty(result) && result.getState().booleanValue()) {
            this.executeJob();
        }
    }

    private void executeJob() {
        List<ObjectFactory<?>> factoryList = ThreadMethodUtil.getMapFactory("post_async", true);
        if (BeanUtils.isNotEmpty(factoryList)) {
            this.logger.info("\u5168\u5c40\u63a5\u53e3\u4e8b\u4ef6\u5f02\u6b65\u8bf7\u6c42");
            factoryList.forEach(ObjectFactory::getObject);
        }
    }
}

