/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.aop;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.Workflow;
import com.hotent.base.entity.BaseModel;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
public class WorkflowAspect {
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;

    @Around(value="execution(* *..*ManagerImpl.*(..)) && @annotation(com.hotent.base.annotation.Workflow)")
    public Object workflow(ProceedingJoinPoint joinPoint) throws Throwable {
        Workflow workflow;
        String flowKey;
        Object returnVal = null;
        Object target = joinPoint.getTarget();
        Class<?> targetClass = target.getClass();
        String methodName = joinPoint.getSignature().getName();
        Object[] params = joinPoint.getArgs();
        Method method = this.getMethodByName(targetClass, methodName);
        BaseModel param = null;
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof BaseModel)) continue;
            param = (BaseModel)((Object)params[i]);
            break;
        }
        if (BeanUtils.isEmpty(param)) {
            returnVal = joinPoint.proceed();
            return returnVal;
        }
        returnVal = joinPoint.proceed();
        if (BeanUtils.isNotEmpty(method) && StringUtil.isNotEmpty(flowKey = (workflow = method.getAnnotation(Workflow.class)).flowKey())) {
            ObjectNode startFlowResult = this.startFlow(workflow, param);
            if (BeanUtils.isNotEmpty(startFlowResult) && startFlowResult.get("state").asBoolean()) {
                String callbackMethodName = workflow.callbackMethodName();
                if (StringUtil.isNotEmpty(callbackMethodName)) {
                    Method callbackMethod = this.getMethodByName(targetClass, callbackMethodName);
                    Assert.notNull((Object)callbackMethod, (String)String.format("\u5f53\u524d\u7c7b\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\uff1a%s\u7684\u56de\u8c03\u65b9\u6cd5", callbackMethodName));
                    callbackMethod.invoke(target, new Object[]{startFlowResult, param});
                }
            } else {
                String message = "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25";
                if (BeanUtils.isNotEmpty(startFlowResult) && BeanUtils.isNotEmpty(startFlowResult.get("message"))) {
                    message = message + ":" + startFlowResult.get("message").asText();
                }
                throw new BaseException(message);
            }
        }
        return returnVal;
    }

    private Method getMethodByName(Class<?> targetClass, String methodName) {
        Method method = null;
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        return method;
    }

    private ObjectNode startFlow(Workflow workflow, BaseModel param) throws Throwable {
        String flowKey = workflow.flowKey();
        String sysCode = workflow.sysCode();
        String[] varKeys = workflow.varKeys();
        ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
        startFlowParam.put("flowKey", flowKey);
        String businessKey = param.getPkVal();
        if (StringUtil.isEmpty(businessKey)) {
            throw new WorkFlowException("\u542f\u52a8\u6d41\u7a0b\u65f6\uff0c\u5b9e\u4f53\u5bf9\u8c61\u4e2d\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        startFlowParam.put("businessKey", businessKey);
        startFlowParam.put("formType", "frame");
        if (StringUtil.isNotEmpty(sysCode)) {
            startFlowParam.put("sysCode", sysCode);
        }
        if (BeanUtils.isNotEmpty(varKeys) && varKeys.length > 0) {
            ObjectNode varsObject = JsonUtil.getMapper().createObjectNode();
            JsonNode paramJsonNode = JsonUtil.toJsonNode((Object)param);
            for (String key : varKeys) {
                JsonNode jsonNode = paramJsonNode.get(key);
                varsObject.set(key, jsonNode);
            }
            startFlowParam.set("vars", (JsonNode)varsObject);
        }
        ObjectNode startFlowResult = this.bpmRuntimeFeignService.start(startFlowParam);
        return startFlowResult;
    }
}

