/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.cache.impl;

import com.hotent.base.cache.CacheManager;
import com.hotent.base.cache.ICache;
import com.hotent.base.cache.impl.DefaultCacheManager;
import com.hotent.base.cache.setting.CacheSetting;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCacheManager
implements CacheManager {
    private Logger logger = LoggerFactory.getLogger(DefaultCacheManager.class);
    protected final ConcurrentMap<String, ConcurrentMap<String, ICache>> cacheContainer = new ConcurrentHashMap<String, ConcurrentMap<String, ICache>>(16);
    private final Set<String> cacheNames = new LinkedHashSet<String>();
    static Set<CacheManager> cacheManagers = new LinkedHashSet<CacheManager>();

    protected abstract ICache getMissingCache(String var1, CacheSetting var2);

    @Override
    public Collection<ICache> getCache(String name) {
        ConcurrentMap cacheMap = (ConcurrentMap)this.cacheContainer.get(name);
        if (CollectionUtils.isEmpty((Map)cacheMap)) {
            return Collections.emptyList();
        }
        return cacheMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICache getCache(String name, CacheSetting cacheSetting) {
        ConcurrentHashMap<String, ICache> cacheMap = (ConcurrentHashMap<String, ICache>)this.cacheContainer.get(name);
        if (!CollectionUtils.isEmpty((Map)cacheMap)) {
            ICache cache;
            if (cacheMap.size() > 1) {
                this.logger.warn("\u7f13\u5b58\u540d\u79f0\u4e3a {} \u7684\u7f13\u5b58,\u5b58\u5728\u4e24\u4e2a\u4e0d\u540c\u7684\u8fc7\u671f\u65f6\u95f4\u914d\u7f6e\uff0c\u8bf7\u4e00\u5b9a\u6ce8\u610f\u4fdd\u8bc1\u7f13\u5b58\u7684key\u552f\u4e00\u6027\uff0c\u5426\u5219\u4f1a\u51fa\u73b0\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4\u9519\u4e71\u7684\u60c5\u51b5", (Object)name);
            }
            if ((cache = (ICache)cacheMap.get(cacheSetting.getInternalKey())) != null) {
                return cache;
            }
        }
        ConcurrentMap<String, ConcurrentMap<String, ICache>> concurrentMap = this.cacheContainer;
        synchronized (concurrentMap) {
            ICache cache;
            cacheMap = (ConcurrentMap)this.cacheContainer.get(name);
            if (!CollectionUtils.isEmpty((Map)cacheMap)) {
                cache = (ICache)cacheMap.get(cacheSetting.getInternalKey());
                if (cache != null) {
                    return cache;
                }
            } else {
                cacheMap = new ConcurrentHashMap<String, ICache>(16);
                this.cacheContainer.put(name, cacheMap);
                this.updateCacheNames(name);
            }
            cache = this.getMissingCache(name, cacheSetting);
            if (cache != null) {
                cache = this.decorateCache(cache);
                cacheMap.put(cacheSetting.getInternalKey(), cache);
                if (cacheMap.size() > 1) {
                    this.logger.warn("\u7f13\u5b58\u540d\u79f0\u4e3a {} \u7684\u7f13\u5b58,\u5b58\u5728\u4e24\u4e2a\u4e0d\u540c\u7684\u8fc7\u671f\u65f6\u95f4\u914d\u7f6e\uff0c\u8bf7\u4e00\u5b9a\u6ce8\u610f\u4fdd\u8bc1\u7f13\u5b58\u7684key\u552f\u4e00\u6027\uff0c\u5426\u5219\u4f1a\u51fa\u73b0\u7f13\u5b58\u8fc7\u671f\u65f6\u95f4\u9519\u4e71\u7684\u60c5\u51b5", (Object)name);
                }
            }
            return cache;
        }
    }

    @Override
    public Collection<String> getCacheNames() {
        return this.cacheNames;
    }

    private void updateCacheNames(String name) {
        this.cacheNames.add(name);
    }

    protected ICache decorateCache(ICache cache) {
        return cache;
    }

    public ConcurrentMap<String, ConcurrentMap<String, ICache>> getCacheContainer() {
        return this.cacheContainer;
    }

    @Override
    public void clearAll() {
        this.cacheContainer.forEach((k, map) -> map.forEach((i, cache) -> cache.clear()));
    }
}

