/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.cache.impl;

import com.hotent.base.cache.ICache;
import com.hotent.base.cache.support.NullValue;
import com.hotent.base.util.JsonUtil;
import org.springframework.util.Assert;

public abstract class AbstractValueAdaptingCache
implements ICache {
    private final String name;

    protected AbstractValueAdaptingCache(String name) {
        Assert.notNull((Object)name, (String)"\u7f13\u5b58\u540d\u79f0\u4e0d\u80fd\u4e3aNULL");
        this.name = name;
    }

    public abstract boolean isAllowNullValues();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        return (T)this.fromStoreValue(this.get(key));
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.isAllowNullValues() && storeValue instanceof NullValue) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.isAllowNullValues() && userValue == null) {
            return NullValue.INSTANCE;
        }
        return userValue;
    }

    protected String toJsonString(Object obj) {
        return JsonUtil.toJsonString(obj);
    }

    public class LoaderCacheValueException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Object key;

        public LoaderCacheValueException(Object key, Throwable ex) {
            super(String.format("\u52a0\u8f7dkey\u4e3a %s \u7684\u7f13\u5b58\u6570\u636e,\u6267\u884c\u88ab\u7f13\u5b58\u65b9\u6cd5\u5f02\u5e38", AbstractValueAdaptingCache.this.toJsonString(key)), ex);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

