/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.cache.CacheManager;
import com.hotent.base.cache.ICache;
import com.hotent.base.conf.JwtConfig;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.util.StringUtil;
import io.jsonwebtoken.lang.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/online/v1/"})
@Api(tags={"\u5728\u7ebf\u7528\u6237"})
@ApiGroup(group={"group_bpm", "group_form", "group_portal", "group_uc"})
public class OnlineUserController {
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    CacheManager cacheManager;
    @Resource
    JwtConfig jwtConfig;
    @Resource
    SaaSConfig saaSConfig;
    ICache cache = null;
    Object nativeCache = null;
    Pattern regex = Pattern.compile(String.format("^%s:(\\w+)_(.*?)_(\\w+)$", "eip:uc:userToken"));

    @PostConstruct
    public void initialNativeCache() {
        Collection<ICache> cacheGroup = this.cacheManager.getCache("eip:uc:userToken");
        if (cacheGroup == null || cacheGroup.size() < 1) {
            return;
        }
        if (!this.jwtConfig.isSingle() || !this.jwtConfig.isStricty()) {
            return;
        }
        if (!this.saaSConfig.isEnable()) {
            this.regex = Pattern.compile(String.format("^%s:(\\w+)_(.*?)_(\\w+)$", "eip:uc:userToken"));
        }
        this.cache = cacheGroup.iterator().next();
        this.nativeCache = this.cache.getNativeCache();
        String canonicalName = this.nativeCache.getClass().getCanonicalName();
        if (StringUtil.isEmpty(canonicalName) || !"org.springframework.data.redis.core.RedisTemplate".equalsIgnoreCase(canonicalName)) {
            this.nativeCache = null;
            return;
        }
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u5728\u7ebf\u7528\u6237")
    public PageList<OnlineUser> online() throws Exception {
        if (null == this.nativeCache) {
            this.initialNativeCache();
        }
        Assert.notNull((Object)this.nativeCache, (String)"\u65e0\u6cd5\u83b7\u53d6\u5728\u7ebf\u7528\u6237\uff0c\u8be5\u529f\u80fd\u9700\u8981\u5f00\u542f\u5355\u7528\u6237\u6a21\u5f0f\u3001\u4e14\u9700\u8981\u5f00\u542fredis\u670d\u52a1\u624d\u80fd\u4f7f\u7528\u3002");
        Object invoke = this.invoke(this.nativeCache, String.format("%s:*", "eip:uc:userToken"));
        Page result = new Page();
        if (invoke instanceof HashSet) {
            HashSet sets = (HashSet)invoke;
            int size = sets.size();
            result.setTotal((long)size);
            ArrayList list = new ArrayList();
            result.setRecords(list);
            sets.forEach(item -> {
                Matcher matcher = this.regex.matcher(item.toString());
                if (matcher.matches()) {
                    String loginType = matcher.group(1);
                    String tenantId = matcher.group(2);
                    String account = matcher.group(3);
                    list.add(new OnlineUser(account, loginType, tenantId));
                }
            });
        }
        return new PageList<OnlineUser>((IPage<OnlineUser>)result);
    }

    @RequestMapping(value={"/kickoff"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8e22\u6307\u5b9a\u7528\u6237\u4e0b\u7ebf", httpMethod="POST", notes="\u8e22\u6307\u5b9a\u7528\u6237\u4e0b\u7ebf")
    public CommonResult<String> kickoff(@ApiParam(name="user", value="\u8d26\u53f7") @RequestBody(required=true) OnlineUser user) throws Exception {
        this.initialNativeCache();
        String account = user.getAccount();
        Assert.isTrue((boolean)StringUtil.isNotEmpty(account), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String loginType = StringUtil.isNotEmpty(user.getLoginType()) ? user.getLoginType() : "pc";
        String tenantId = StringUtil.isNotEmpty(user.getTenantId()) ? user.getTenantId() : "-1";
        this.jwtTokenHandler.removeFromCache(loginType, tenantId, account);
        return new CommonResult<String>();
    }

    private Object invoke(Object obj, String param) throws Exception {
        Class<?> clazz = obj.getClass();
        Method method = clazz.getMethod("keys", Object.class);
        return method.invoke(obj, param);
    }

    @ApiModel(description="\u7528\u6237\u8868")
    public static class OnlineUser
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @ApiModelProperty(value="\u8d26\u53f7")
        private String account;
        @ApiModelProperty(value="\u8bbe\u5907\u7c7b\u578b", allowableValues="pc,mobile")
        private String loginType;
        @ApiModelProperty(value="\u79df\u6237ID")
        private String tenantId;

        public OnlineUser() {
        }

        public OnlineUser(String account, String loginType, String tenantId) {
            this.account = account;
            this.loginType = loginType;
            this.tenantId = tenantId;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }
    }
}

