/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.controller;

import com.baomidou.dynamic.datasource.toolkit.CryptoUtils;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.cache.CacheManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.PinyinUtil;
import com.hotent.base.util.RSAUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.vo.DruidEncryptDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/tools/v1/"})
@Api(tags={"\u5de5\u5177\u63a5\u53e3"})
@ApiGroup(group={"group_bpm", "group_form", "group_portal", "group_uc"})
public class ToolsController {
    @Value(value="${spring.profiles.version:''}")
    String platformVersion;

    @RequestMapping(value={"getPinyin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u62fc\u97f3", httpMethod="GET", notes="\u83b7\u53d6\u62fc\u97f3")
    public CommonResult<String> getPinyin(@ApiParam(required=true, name="chinese", value="\u4e2d\u6587\u5185\u5bb9") @RequestParam Optional<String> chinese, @ApiParam(name="type", value="\u7c7b\u578b\u662f1 \u5219\u4e3a\u5168\u62fc\uff0c\u5426\u5219\u4e3a\u9996\u5b57\u6bcd") @RequestParam Optional<Integer> type) throws AuthenticationException {
        String pinying = "";
        if (StringUtil.isEmpty(chinese.orElse(""))) {
            return new CommonResult<String>(true, "\u83b7\u53d6\u62fc\u97f3\u6210\u529f\uff01", pinying);
        }
        Integer ptype = type.orElse(1);
        pinying = ptype == 1 ? PinyinUtil.getPinyin(chinese.get()) : PinyinUtil.getPinYinHeadChar(chinese.get());
        return new CommonResult<String>(true, "\u83b7\u53d6\u62fc\u97f3\u6210\u529f\uff01", pinying);
    }

    @RequestMapping(value={"getPublicKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6RSA\u52a0\u5bc6\u7684\u516c\u94a5", httpMethod="GET", notes="\u83b7\u53d6RSA\u52a0\u5bc6\u7684\u516c\u94a5")
    public CommonResult<String> getPublicKey() throws Exception {
        return CommonResult.ok().value(RSAUtil.publicKey);
    }

    @RequestMapping(value={"getPlatformVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e73\u53f0\u7248\u672c", httpMethod="GET", notes="\u83b7\u53d6\u5e73\u53f0\u7248\u672c")
    public CommonResult<String> getPlatformVersion() {
        return new CommonResult<String>(true, "", this.platformVersion);
    }

    @RequestMapping(value={"encryptDbPassword"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u5bc6\u7801\u52a0\u5bc6\u5b57\u7b26\u4e32", httpMethod="POST", notes="\u83b7\u53d6\u6570\u636e\u5e93\u5bc6\u7801\u52a0\u5bc6\u4fe1\u606f")
    public CommonResult<DruidEncryptDTO> encryptDbPassword(@ApiParam(required=true, name="password", value="\u5f85\u52a0\u5bc6\u5bc6\u7801") @RequestBody Map<String, String> map) throws Exception {
        String[] arr = CryptoUtils.genKeyPair((int)512);
        DruidEncryptDTO druidEncryptDTO = new DruidEncryptDTO();
        druidEncryptDTO.setPassword(CryptoUtils.encrypt((String)arr[0], (String)map.get("password")));
        druidEncryptDTO.setPublicKey(arr[1]);
        return new CommonResult<DruidEncryptDTO>(true, "\u83b7\u53d6\u62fc\u97f3\u6210\u529f\uff01", druidEncryptDTO);
    }

    @RequestMapping(value={"clearCacheByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f13\u5b58key\u6e05\u9664\u7f13\u5b58", httpMethod="GET", notes="\u6839\u636e\u7f13\u5b58key\u6e05\u9664\u7f13\u5b58")
    public CommonResult<String> clearCacheByKey(@ApiParam(required=true, name="key", value="\u7f13\u5b58key") @RequestParam String key) throws AuthenticationException {
        CacheManager manager = AppUtil.getBean(CacheManager.class);
        manager.clearCascadeByKey(key);
        return new CommonResult<String>(true, "\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"getYmlValueByName"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6value", httpMethod="GET", notes="\u591a\u4e2a\u9017\u53f7\u5206\u9694")
    public CommonResult<Map<String, String>> getYmlValueByName(@ApiParam(required=true, name="keys", value="keys") @RequestParam String keys) throws AuthenticationException {
        Environment environment = AppUtil.getApplicaitonContext().getEnvironment();
        String[] split = keys.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : split) {
            String value = environment.getProperty(key);
            map.put(key, value);
        }
        CommonResult<Map<String, String>> commonResult = new CommonResult<Map<String, String>>(true, "\u83b7\u53d6\u6210\u529f");
        commonResult.setValue(map);
        return commonResult;
    }

    @RequestMapping(value={"getCurrentDate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684\u65f6\u95f4", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684\u65f6\u95f4")
    public CommonResult<String> getCurrentDate(@ApiParam(required=true, name="valFormat", value="\u65e5\u671f\u683c\u5f0f") @RequestParam String valFormat) throws AuthenticationException {
        String date = DateUtil.getCurrentTime(valFormat);
        return new CommonResult<String>(true, "\u83b7\u53d6\u6210\u529f", date);
    }

    @RequestMapping(value={"getCurrentDbType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u5f53\u524d\u6570\u636e\u6e90\u7684\u6570\u636e\u5e93\u7c7b\u578b", httpMethod="GET", notes="\u53d6\u5f97\u5f53\u524d\u6570\u636e\u6e90\u7684\u6570\u636e\u5e93\u7c7b\u578b")
    public CommonResult<String> getCurrentDbType() {
        return new CommonResult<String>(true, "\u83b7\u53d6\u6210\u529f", SQLUtil.getDbType());
    }
}

