/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.filter;

import com.hotent.base.request.CustomHttpServletRequestWrapper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="DataFilterFilter", urlPatterns={"/*"})
public class DataFilterFilter
implements Filter {
    public static final Logger log = LoggerFactory.getLogger(DataFilterFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contentType;
        CustomHttpServletRequestWrapper customHttpServletRequestWrapper = null;
        if (request instanceof HttpServletRequest && ((contentType = request.getContentType()) == null || !contentType.startsWith("multipart/form-data"))) {
            try {
                HttpServletRequest req = (HttpServletRequest)request;
                customHttpServletRequestWrapper = new CustomHttpServletRequestWrapper(req);
            }
            catch (Exception e) {
                log.warn("customHttpServletRequestWrapper Error:", (Throwable)e);
            }
        }
        chain.doFilter((ServletRequest)(Objects.isNull(customHttpServletRequestWrapper) ? request : customHttpServletRequestWrapper), response);
    }
}

