/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.filter;

import com.hotent.base.conf.SecurityConfig;
import com.hotent.base.request.XssHttpServletRequestWraper;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XssFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    SecurityConfig securityConfig;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!this.securityConfig.isEnabled() || this.isExcludeUrl(request.getServletPath()) || this.isUploadUrl(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        XssHttpServletRequestWraper xssHttpServletRequestWraper = new XssHttpServletRequestWraper(request);
        filterChain.doFilter((ServletRequest)xssHttpServletRequestWraper, servletResponse);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterconfig1) throws ServletException {
    }

    private boolean isExcludeUrl(String url) {
        List<String> xssExcludes = this.securityConfig.getXssExcludes();
        if (BeanUtils.isEmpty(xssExcludes)) {
            return false;
        }
        return xssExcludes.stream().map(pattern -> Pattern.compile("^" + pattern)).map(p -> p.matcher(url)).anyMatch(Matcher::find);
    }

    private boolean isUploadUrl(HttpServletRequest request) {
        String contentType = request.getContentType();
        return StringUtil.isNotEmpty(contentType) && contentType.toLowerCase().contains("multipart/form-data;");
    }
}

