/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.handler;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.aop.AopCacheHelper;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.exception.NormalException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.ExceptionLogService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.WebUtil;
import com.hotent.base.util.time.DateUtil;
import feign.FeignException;
import feign.RetryableException;
import java.io.Serializable;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ibatis.binding.BindingException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.RestClientException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice(annotations={RestController.class, Controller.class})
public class BaseExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    ExceptionLogService exceptionLogService;
    private static Pattern regexDuplicateKeyMysql = Pattern.compile("\\'[^']+\\'");
    private static Pattern regexDuplicateKeyOracle = Pattern.compile("\\([^)]+\\)");
    private static String moduleType = "base";
    static final List<String> IGNORE_EXCEPTION_MESSAGE = Arrays.asList("org.activiti.engine.ActivitiException:", "Exception while invoking TaskListener:", "com.hotent.base.exception.", "\u4efb\u52a1\u529e\u7406\u5931\u8d25:", "BaseException:", "WorkFlowException: ", "NoTaskUserException: ");

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public CommonResult<String> badRequest(BindException e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        this.exceptionLogService.save((Exception)e);
        return new CommonResult<String>(ResponseErrorEnums.BAD_REQUEST);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public CommonResult<String> badRequestNotFound(BindException e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        this.exceptionLogService.save((Exception)e);
        return new CommonResult<String>(ResponseErrorEnums.NOT_FOUND);
    }

    @ExceptionHandler(value={BindingException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> mybatis(Exception e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        this.exceptionLogService.save(e);
        return new CommonResult<String>(ResponseErrorEnums.BOUND_STATEMENT_NOT_FOUNT);
    }

    @ExceptionHandler(value={RejectedExecutionException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> rejectedExecution(Exception e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        return new CommonResult<String>(ResponseErrorEnums.REJECTED_EXECUTION_ERROR);
    }

    @ExceptionHandler(value={BaseException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public <T extends Serializable> CommonResult<T> sendError(BaseException exception, HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String opContent = this.getErrorDetail(exception);
        this.log.error("occurs error when execute url ={} ,message {}", new Object[]{requestUri, exception.getMessage(), exception});
        String errorId = this.exceptionLogService.save(opContent);
        if (exception.getResponseErrorEnums() != null) {
            return CommonResult.result(exception.getResponseErrorEnums(), exception.getMessage()).log(errorId);
        }
        return CommonResult.error().log(errorId).message(exception.getMessage());
    }

    @ExceptionHandler(value={SQLException.class, DataAccessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> systemError(Exception e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        String errorId = this.exceptionLogService.save(e);
        if (e instanceof MyBatisSystemException) {
            return new CommonResult<String>(((MyBatisSystemException)e).getRootCause().getMessage());
        }
        CommonResult<String> commonResult = new CommonResult<String>(ResponseErrorEnums.DATABASE_ERROR);
        commonResult.setMessage("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={ConnectException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> connect(Exception e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        this.exceptionLogService.save(e);
        return new CommonResult<String>(ResponseErrorEnums.CONNECTION_ERROR);
    }

    @ExceptionHandler(value={FeignException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> hystrixRuntimeError(FeignException e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        CommonResult<String> result = e.getCause() instanceof TimeoutException || e.getCause() instanceof RetryableException ? new CommonResult<String>(ResponseErrorEnums.SERVICE_INVOKE_ERROR, "\u670d\u52a1\u8c03\u7528\u8d85\u65f6\uff1a" + e.getLocalizedMessage()) : new CommonResult(false, "\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        this.exceptionLogService.save((Exception)e);
        return result;
    }

    private String getErrorDetail(BaseException e) {
        String opeContent = BeanUtils.isNotEmpty(ExceptionUtil.getRootCauseMessage(e)) ? ExceptionUtil.getFullStackTrace(ExceptionUtil.getRootCause(e)) : ExceptionUtil.getFullStackTrace(e);
        return opeContent;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> runTimeError(Exception e) {
        String[] msgs;
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        String errorMsg = ExceptionUtil.getRootCauseMessage(e);
        String flowErrorMsg = ThreadMsgUtil.getMapMsg("msg_flow_error", true);
        if (StringUtil.isNotEmpty(errorMsg) && errorMsg.contains("\u6d41\u7a0b\u5f02\u5e38") && StringUtil.isNotEmpty(flowErrorMsg)) {
            errorMsg = flowErrorMsg;
        } else if (StringUtil.isNotEmpty(errorMsg) && (msgs = errorMsg.split("Exception:")).length == 2) {
            errorMsg = msgs[1];
        }
        String errorId = this.exceptionLogService.save(e);
        CommonResult<String> commonResult = new CommonResult<String>(false, BaseExceptionHandler.formatMsg(errorMsg));
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> notAllowed(Exception e) {
        String errorMsg = BeanUtils.isNotEmpty(ExceptionUtil.extractMessageFromXML(e.getMessage())) ? ExceptionUtil.extractMessageFromXML(e.getMessage()) : e.getMessage();
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        String errorId = this.exceptionLogService.save(e);
        CommonResult<String> commonResult = new CommonResult<String>(false, BaseExceptionHandler.formatMsg(errorMsg));
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> methodArgumentNotValidException(MethodArgumentNotValidException e) {
        StringBuffer stringBuffer = new StringBuffer();
        BindingResult bindingResult = e.getBindingResult();
        bindingResult.getAllErrors().forEach(error -> stringBuffer.append(error.getDefaultMessage()).append(" "));
        this.log.error("occurs error when execute method ,message {}", (Object)stringBuffer);
        return CommonResult.result(ResponseErrorEnums.ILLEGAL_ARGUMENT).message(stringBuffer.toString());
    }

    @ExceptionHandler(value={MessagePassingException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> dataOutOrLimitExceptionHandler(MessagePassingException e) {
        this.log.error("\u53c2\u6570\u4e0d\u5408\u6cd5{}", (Object)e.getMessage(), (Object)e);
        return CommonResult.result(ResponseErrorEnums.ILLEGAL_ARGUMENT).message(e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> unrecognizedPropertyExceptionHandler(HttpMessageNotReadableException e) {
        if (e.getCause() instanceof UnrecognizedPropertyException) {
            this.log.error("\u53c2\u6570\u542b\u6709\u975e\u6cd5\u5b57\u7b26,\u6709xss\u653b\u51fb\u7684\u98ce\u9669{}", (Object)e.getMessage(), (Object)e);
            return CommonResult.result(ResponseErrorEnums.XSS_ATTACK).message(e.getMessage());
        }
        return this.runTimeError((Exception)e);
    }

    public static String formatMsg(String msg) {
        if (StringUtil.isEmpty(msg)) {
            return msg;
        }
        for (String message : IGNORE_EXCEPTION_MESSAGE) {
            msg = msg.replaceAll(message, "");
        }
        return msg.trim();
    }

    @ExceptionHandler(value={NormalException.class})
    @ResponseBody
    public CommonResult<String> normalExceptionHandler(NormalException e) {
        this.log.error("normalException:{}", (Object)ExceptionUtil.getRootCauseMessage(e));
        return new CommonResult<String>(false, e.getMessage());
    }

    @ExceptionHandler(value={RestClientException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> restTemplateError(Exception e) {
        this.log.error("occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        String errorId = this.exceptionLogService.save(e);
        CommonResult<String> commonResult = new CommonResult<String>(false, "\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> duplicateKeyExceptionHandler(Exception e) {
        String opeContent = ExceptionUtil.getFullStackTrace(e);
        this.log.error("[ExceptionHandler]occurs error when execute method ,message {}", (Throwable)e);
        String errorId = this.saveExceptionLogs(opeContent);
        String errorMsg = "";
        Matcher regexMatcher = regexDuplicateKeyMysql.matcher(e.getCause().getMessage());
        if (!regexMatcher.find()) {
            regexMatcher = regexDuplicateKeyOracle.matcher(e.getCause().getMessage());
        }
        while (regexMatcher.find()) {
            String[] arr;
            String indexName;
            String msg = regexMatcher.group(0);
            if (!msg.contains(".") || !StringUtil.isNotEmpty(indexName = (arr = msg.split("\\."))[1])) continue;
            indexName = indexName.replace("'", "").replace(")", "");
            String concatChar = StringUtil.isEmpty(errorMsg) ? "" : ",";
            errorMsg = errorMsg + concatChar + indexName;
        }
        if (StringUtil.isEmpty(errorMsg)) {
            errorMsg = "\u60a8\u586b\u5199\u7684\u5185\u5bb9\u6709\u91cd\u590d\uff0c\u8bf7\u6838\u67e5\uff01";
        }
        CommonResult<String> commonResult = new CommonResult<String>(false, errorMsg);
        commonResult.setLogId(errorId);
        return commonResult;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public CommonResult<String> missingServletRequestParameterExceptionHandler(Exception e) {
        this.log.error("[MissingServletRequestParameterException]occurs error when execute method ,message {}", (Object)e.getMessage(), (Object)e);
        try {
            HttpServletRequest request = HttpUtil.getRequest();
            if (request != null) {
                String uri = request.getRequestURI();
                String params = "";
                if (CollUtil.isNotEmpty((Map)request.getParameterMap())) {
                    params = JsonUtil.toJsonString(request.getParameterMap());
                }
                this.log.error(String.format("\u8bf7\u6c42\u94fe\u63a5\uff1a%s\uff1b\u53c2\u6570\uff1a%s", uri, params));
            }
        }
        catch (Exception request) {
            // empty catch block
        }
        String errorId = this.exceptionLogService.save(e);
        CommonResult<String> commonResult = new CommonResult<String>(false, "\u7f3a\u5931\u8bf7\u6c42\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u67e5\u770b\u65e5\u5fd7\uff01");
        commonResult.setLogId(errorId);
        return commonResult;
    }

    private String saveExceptionLogs(String opeContent) {
        AopCacheHelper aopCacheHelper = AppUtil.getBean(AopCacheHelper.class);
        JmsProducer jmsProducer = AppUtil.getBean(JmsProducer.class);
        String errorId = "";
        try {
            Map<String, String> cacheSettings = aopCacheHelper.getSysLogsSettingStatusMap();
            if (BeanUtils.isEmpty(cacheSettings) || !cacheSettings.containsKey(moduleType)) {
                this.log.error("\u672a\u83b7\u53d6\u5230\u65e5\u5fd7\u914d\u7f6e\u4e2d\u5173\u4e8e\u6a21\u5757\uff1a{}\u7684\u65e5\u5fd7\u914d\u7f6e\uff0c\u8df3\u8fc7\u8be5\u6a21\u5757\u7684\u65e5\u5fd7\u8bb0\u5f55\u3002", (Object)moduleType);
            }
            String executor = "\u7cfb\u7edf[\u65e0\u7528\u6237\u767b\u5f55\u7cfb\u7edf]";
            if (StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())) {
                executor = String.format("%s[%s]", AuthenticationUtil.getCurrentUserFullname(), AuthenticationUtil.getCurrentUsername());
            }
            HttpServletRequest request = HttpUtil.getRequest();
            String reqUrl = HttpUtil.getRequest().getRequestURI();
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            errorId = UniqueIdUtil.getSuid();
            objectNode.put("id", errorId);
            objectNode.put("opeName", "\u7cfb\u7edf\u5f02\u5e38");
            objectNode.put("moduleType", moduleType);
            objectNode.put("reqUrl", reqUrl);
            objectNode.put("opeContent", opeContent);
            objectNode.put("type", "sysLog");
            objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
            String tenantId = HttpUtil.getTenantId();
            if (BeanUtils.isEmpty(tenantId)) {
                tenantId = "-1";
            }
            objectNode.put("tenantId", tenantId);
            objectNode.put("logType", "\u5f02\u5e38\u65e5\u5fd7");
            if (BeanUtils.isNotEmpty(cacheSettings) && cacheSettings.containsKey(moduleType) && "1".equals(cacheSettings.get(moduleType))) {
                objectNode.put("executor", executor);
                objectNode.put("ip", WebUtil.getIpAddr(request));
                jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysLogQueue");
            }
        }
        catch (Exception err) {
            this.log.error("\u4fdd\u5b58\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25\u3002" + ExceptionUtils.getFullStackTrace((Throwable)err));
        }
        return errorId;
    }
}

