/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.interceptor;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.DbHealthIndicator;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MasterSlaveAutoRoutingPlugin
implements Interceptor,
ContextThread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MASTER = "master";
    public static final String SLAVE = "slave";
    public static ThreadLocal<Boolean> inExternalDatasource = new ThreadLocal();
    @Autowired
    private DynamicDataSourceProperties properties;

    public static boolean getInExternalDatasource() {
        Boolean result = inExternalDatasource.get();
        return BeanUtils.isNotEmpty(result) && result != false;
    }

    public static void setInExternalDatasource() {
        inExternalDatasource.set(true);
    }

    public static void removeInExternalDatasource() {
        inExternalDatasource.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (MasterSlaveAutoRoutingPlugin.getInExternalDatasource()) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        try {
            String result = MASTER;
            if (SqlCommandType.SELECT == ms.getSqlCommandType() && this.getDataSource(ms)) {
                result = SLAVE;
                this.log.info("\u64cd\u4f5c\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u4f7f\u7528\u7684\u6570\u636e\u5e93\u4e3a\uff1a{}", (Object)ms.getSqlCommandType(), (Object)result);
            }
            DynamicDataSourceContextHolder.push((String)result);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    public boolean getDataSource(MappedStatement mappedStatement) {
        Map datasource = this.properties.getDatasource();
        if (datasource == null || !datasource.containsKey(SLAVE)) {
            return false;
        }
        if (this.properties.isHealth()) {
            return DbHealthIndicator.getDbHealth((String)SLAVE);
        }
        return true;
    }

    public Object plugin(Object target) {
        return target instanceof Executor ? Plugin.wrap((Object)target, (Interceptor)this) : target;
    }

    public void setProperties(Properties properties) {
    }

    @Override
    public void cleanAll() {
        MasterSlaveAutoRoutingPlugin.removeInExternalDatasource();
    }
}

