/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.seata.rm.datasource.undo.parser.UndoLogSerializerClassRegistry;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoLogSerializerClassRegistryUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(UndoLogSerializerClassRegistryUtil.class);

    public static void register() {
        UndoLogSerializerClassRegistry.registerClass(SerialClob.class, (Object)((Object)new ClobSerializer()));
    }

    private static class ClobSerializer
    extends Serializer<Clob> {
        private ClobSerializer() {
        }

        public void write(Kryo kryo, Output output, Clob object) {
            try {
                String s = "";
                if (object.length() > 0L) {
                    s = object.getSubString(1L, (int)object.length());
                }
                output.writeString(s);
            }
            catch (SQLException e) {
                LOGGER.error("kryo write java.sql.Clob error: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        public Clob read(Kryo kryo, Input input, Class<Clob> type) {
            try {
                String s = input.readString();
                return new SerialClob(s.toCharArray());
            }
            catch (SQLException e) {
                LOGGER.error("kryo read java.sql.Clob error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }
}

