/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.model;

import com.hotent.base.enums.ResponseErrorEnums;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="\u901a\u7528\u8fd4\u56de\u7ed3\u679c")
public class CommonResult<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="state", notes="\u72b6\u6001 true\uff1a\u64cd\u4f5c\u6210\u529f  false\uff1a\u64cd\u4f5c\u5931\u8d25")
    Boolean state = true;
    @ApiModelProperty(name="message", notes="\u63d0\u793a\u4fe1\u606f")
    String message;
    @ApiModelProperty(name="value", notes="\u8fd4\u56de\u7684\u6570\u636e")
    E value;
    @ApiModelProperty(value="\u6807\u51c6\u7684http\u72b6\u6001\u7801\uff1a200, 400, 401, 500\u7b49")
    private Integer code = 200;
    @ApiModelProperty(value="\u9519\u8bef\u4ee3\u7801")
    private String errorCode;
    @ApiModelProperty(value="\u65e5\u5fd7ID")
    private String logId;

    public static <E> CommonResult<E> ok() {
        CommonResult<E> cr = new CommonResult<E>(ResponseErrorEnums.SUCCESS_OPTION);
        return cr;
    }

    public static <E> CommonResult<E> success(E e) {
        CommonResult<E> cr = new CommonResult<E>();
        cr.setState(true);
        cr.setValue(e);
        cr.setCode(ResponseErrorEnums.SUCCESS_OPTION.getHttpCode());
        return cr;
    }

    public static <E> CommonResult<E> error(String message) {
        CommonResult<Object> cr = new CommonResult<Object>(false, message, null);
        return cr;
    }

    public static <E> CommonResult<E> error() {
        CommonResult<E> cr = new CommonResult<E>(ResponseErrorEnums.SYSTEM_ERROR);
        return cr;
    }

    public static <E> CommonResult<E> result(ResponseErrorEnums res) {
        CommonResult<E> cr = new CommonResult<E>(res);
        return cr;
    }

    public static <E> CommonResult<E> result(ResponseErrorEnums res, String message) {
        CommonResult<E> cr = new CommonResult<E>(res);
        cr.setMessage(message);
        return cr;
    }

    public CommonResult<E> message(String message) {
        this.setMessage(message);
        return this;
    }

    public CommonResult<E> value(E val) {
        this.setValue(val);
        return this;
    }

    public CommonResult<E> log(String logId) {
        this.setLogId(logId);
        return this;
    }

    public CommonResult() {
    }

    public CommonResult(String message) {
        this(true, message, null);
    }

    public CommonResult(boolean state, String message) {
        this(state, message, null);
    }

    public CommonResult(boolean state, String message, E value) {
        this.state = state;
        this.message = message;
        this.value = value;
    }

    public CommonResult(ResponseErrorEnums error) {
        if (!error.getCode().equals("200")) {
            this.state = false;
        }
        this.errorCode = error.getCode();
        this.message = error.getMessage();
        this.code = error.getHttpCode();
    }

    public CommonResult(ResponseErrorEnums error, E value) {
        if (!error.getCode().equals("200")) {
            this.state = false;
        }
        this.errorCode = error.getCode();
        this.message = error.getMessage();
        this.code = error.getHttpCode();
        this.value = value;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

