/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.request;

import cn.hutool.core.util.ClassUtil;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.DataPermissionEnums;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.request.CustomHttpServletRequestWrapper;
import com.hotent.base.security.MethodAuthService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@Component
public class DataFilterInterceptor
implements HandlerInterceptor {
    private static final String dataFilterGroupName = "__dataFilter";
    @Resource
    private MethodAuthService methodAuthService;
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    BaseContext baseContext;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        MethodParameter[] methodParameters;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (AuthenticationUtil.isAnonymous(authentication)) {
            return true;
        }
        String requestHeader = request.getHeader("Proxy-Authorization");
        if (StringUtil.isNotEmpty(requestHeader) && requestHeader.startsWith("Bearer ") && this.jwtTokenHandler.validateFeignToken(requestHeader.substring(7)).booleanValue()) {
            return true;
        }
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        String requestURI = request.getRequestURI();
        String currentMenuAlias = request.getHeader("CurrentMenuAlias");
        Set roleAliases = authentication.getAuthorities().stream().map(m -> m.getAuthority()).collect(Collectors.toSet());
        List<HashMap<String, String>> methodDataFitlers = this.methodAuthService.getMethodDataFitlers();
        Optional<HashMap> filter = methodDataFitlers.stream().filter(f -> Objects.equals(currentMenuAlias, f.get("menuAlias")) && new AntPathRequestMatcher((String)f.get("methodRequestUrl")).matches(request) && roleAliases.contains(f.get("roleAlias"))).min(Comparator.comparing(map -> {
            String permission;
            switch (permission = (String)map.get("dataPermission")) {
                case "all": {
                    return 1;
                }
                case "deptSub": {
                    return 2;
                }
                case "dept": {
                    return 3;
                }
                case "owner": {
                    return 4;
                }
            }
            return 5;
        }));
        String dataPermission = null;
        if (!filter.isPresent() || BeanUtils.isEmpty(dataPermission = (String)filter.get().get("dataPermission")) || DataPermissionEnums.all.name().equals(dataPermission)) {
            return true;
        }
        for (MethodParameter parameter : methodParameters = ((HandlerMethod)handler).getMethodParameters()) {
            Class parameterType = parameter.getParameterType();
            if (!ClassUtil.isAssignable(QueryFilter.class, (Class)parameterType) || !(request instanceof CustomHttpServletRequestWrapper)) continue;
            CustomHttpServletRequestWrapper requestWrapper = (CustomHttpServletRequestWrapper)request;
            String body = requestWrapper.getBody();
            QueryFilter queryFilter = JsonUtil.toBean(body, QueryFilter.class);
            if (queryFilter.getQuerys() == null) {
                queryFilter.setQuerys(new ArrayList<QueryField>());
            }
            UCFeignService ucFeignService = AppUtil.getBean(UCFeignService.class);
            if (DataPermissionEnums.owner.name().equals(dataPermission)) {
                queryFilter.addFilter("create_by_", this.baseContext.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, dataFilterGroupName);
            } else if (DataPermissionEnums.dept.name().equals(dataPermission)) {
                List<String> orgIdsByUserId = ucFeignService.getOrgIdsByUserId(this.baseContext.getCurrentUserId());
                queryFilter.addFilter("create_org_id_", orgIdsByUserId, QueryOP.IN, FieldRelation.AND, dataFilterGroupName);
            } else if (DataPermissionEnums.deptSub.name().equals(dataPermission)) {
                List<String> allSubOrgIds = ucFeignService.getAllSubOrgIdsByUserId(this.baseContext.getCurrentUserId());
                queryFilter.addFilter("create_org_id_", allSubOrgIds, QueryOP.IN, FieldRelation.AND, dataFilterGroupName);
            }
            requestWrapper.setBody(JsonUtil.toJson(queryFilter));
        }
        return true;
    }
}

