/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.request;

import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public static final Logger log = LoggerFactory.getLogger(SqlInjectHttpServletRequestWrapper.class);
    private static final String CHARSET_NAME = "UTF-8";
    private byte[] body;
    private HttpServletRequest request;
    private Pattern sqlPattern = Pattern.compile("(?:%)|(?:\\.\\.)|(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select |select\\+|update |delete |insert |trancate |char|substr|ascii|declare|exec|count|master|into|drop |execute)\\b)", 2);

    public SqlInjectHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String getBodyString() {
        try {
            return this.inputStream2String((InputStream)this.request.getInputStream());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getHeader(String v) {
        String header = super.getHeader(v);
        if (header == null || "".equals(header)) {
            return header;
        }
        return this.sqlFilter(header);
    }

    public String getParameter(String v) {
        String param = super.getParameter(v);
        if (param == null || "".equals(param)) {
            return param;
        }
        return this.sqlFilter(param);
    }

    public String[] getParameterValues(String v) {
        String[] values = super.getParameterValues(v);
        if (values == null) {
            return values;
        }
        int length = values.length;
        String[] resultValues = new String[length];
        for (int i = 0; i < length; ++i) {
            resultValues[i] = this.sqlFilter(values[i]);
            if (resultValues[i].equals(values[i])) continue;
            log.debug("SQL\u6ce8\u5165\u8fc7\u6ee4\u5668 => \u8fc7\u6ee4\u524d\uff1a{} => \u8fc7\u6ee4\u540e\uff1a{}", (Object)values[i], (Object)resultValues[i]);
        }
        return resultValues;
    }

    public ServletInputStream getInputStream() throws IOException {
        this.body = this.getBodyString().getBytes(Charset.forName(CHARSET_NAME));
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    private String sqlFilter(String v) {
        if (v != null) {
            String resultVal = v;
            Matcher matcher = this.sqlPattern.matcher(resultVal);
            if (matcher.find()) {
                throw new BaseException(ResponseErrorEnums.SQL_INJECT);
            }
            if (!resultVal.equals(v)) {
                return "";
            }
            return resultVal;
        }
        return null;
    }

    private String inputStream2String(InputStream inputStream) {
        String result = ((Stream)new BufferedReader(new InputStreamReader(inputStream)).lines().parallel()).collect(Collectors.joining("\n"));
        this.sqlFilter(result);
        return result;
    }
}

