/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.request;

import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWraper
extends HttpServletRequestWrapper {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String CHARSET_NAME = "UTF-8";
    private byte[] body;
    private HttpServletRequest request;
    private static Pattern[] patterns = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42), Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42), Pattern.compile("</script>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42), Pattern.compile("alert(.*?)", 42), Pattern.compile("<", 40), Pattern.compile(">", 40), Pattern.compile("((alert|on\\w+|function\\s+\\w+)\\s*\\(\\s*(['+\\d\\w](,?\\s*['+\\d\\w]*)*)*\\s*\\))"), Pattern.compile("(<(script|iframe|embed|frame|frameset|object|img|applet|body|html|style|layer|link|ilayer|meta|bgsound))")};

    public XssHttpServletRequestWraper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String getBodyString() {
        try {
            return this.inputStream2String((InputStream)this.request.getInputStream());
        }
        catch (IOException e) {
            this.log.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String[] getParameterValues(String v) {
        String[] values = super.getParameterValues(v);
        if (values == null) {
            return values;
        }
        int length = values.length;
        String[] resultValues = new String[length];
        for (int i = 0; i < length; ++i) {
            resultValues[i] = this.checkIsXss(values[i]);
        }
        return resultValues;
    }

    public String getParameter(String v) {
        String param = super.getParameter(v);
        if (param == null || "".equals(param)) {
            return param;
        }
        return this.checkIsXss(param);
    }

    public ServletInputStream getInputStream() throws IOException {
        this.body = this.getBodyString().getBytes(Charset.forName(CHARSET_NAME));
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    private String inputStream2String(InputStream inputStream) {
        String result = ((Stream)new BufferedReader(new InputStreamReader(inputStream)).lines().parallel()).collect(Collectors.joining("\n"));
        this.checkIsXss(result);
        return result;
    }

    public String checkIsXss(String v) {
        if (v != null) {
            String resultVal = v;
            for (Pattern scriptPattern : patterns) {
                Matcher matcher = scriptPattern.matcher(resultVal);
                if (!matcher.find()) continue;
                throw new BaseException(ResponseErrorEnums.XSS_ATTACK);
            }
            if (!resultVal.equals(v)) {
                return "";
            }
            return resultVal;
        }
        return null;
    }
}

