/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.security;

import com.google.common.collect.Lists;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.constants.PlatformConsts;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.security.MethodAuthService;
import com.hotent.base.security.dto.SysAuthResource;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Service;

@Service
public class HtInvocationSecurityMetadataSourceService
implements FilterInvocationSecurityMetadataSource,
ContextThread {
    private static ThreadLocal<List<SysAuthResource>> mapThreadLocal = new ThreadLocal();
    private static final Set<String> excludeUrls = new HashSet<String>();
    @Resource
    private MethodAuthService methodAuthService;
    @Resource
    JwtTokenHandler jwtTokenHandler;

    public void loadResourceDefine() {
        List<HashMap<String, String>> methodAuth = this.methodAuthService.getMethodAuth();
        ArrayList<SysAuthResource> authResourceList = new ArrayList<SysAuthResource>();
        methodAuth.forEach(e -> {
            SysAuthResource sysAuthResource = new SysAuthResource((String)e.get("methodAlias"), (String)e.get("menuAlias"), (String)e.get("followMenu"), (String)e.get("methodRequestUrl"), (String)e.get("roleAliases"));
            authResourceList.add(sysAuthResource);
        });
        HtInvocationSecurityMetadataSourceService.setMapThreadLocal(authResourceList);
    }

    @CachePut(value={"eip:sys:dataPermission"}, key="#key")
    protected String putDataPermissionInCache(String key, String data) {
        return data;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        String resUrl = null;
        String currentMenuAlias = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (AuthenticationUtil.isAnonymous(authentication)) {
            return null;
        }
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String requestHeader = request.getHeader("Proxy-Authorization");
        if (StringUtil.isNotEmpty(requestHeader) && requestHeader.startsWith("Bearer ") && this.jwtTokenHandler.validateFeignToken(requestHeader.substring(7)).booleanValue()) {
            return null;
        }
        if (object instanceof FilterInvocation) {
            FilterInvocation filterInvocation = (FilterInvocation)object;
            String method = filterInvocation.getRequest().getMethod();
            resUrl = filterInvocation.getRequestUrl();
            currentMenuAlias = filterInvocation.getRequest().getHeader("CurrentMenuAlias");
            if (HttpMethod.OPTIONS.matches(method)) {
                return null;
            }
            if (excludeUrls.contains(resUrl)) {
                return null;
            }
        }
        this.loadResourceDefine();
        return this.getAttributesWithMenuAndResUrl(currentMenuAlias, resUrl, request);
    }

    private Collection<ConfigAttribute> getAttributesWithMenuAndResUrl(String menuAlias, String resUrl, HttpServletRequest request) {
        List<SysAuthResource> sysAuthResourceList = HtInvocationSecurityMetadataSourceService.getMapThreadLocal();
        if (BeanUtils.isEmpty(menuAlias)) {
            Optional<SysAuthResource> any = sysAuthResourceList.stream().filter(f -> new AntPathRequestMatcher(f.getMethodRequestUrl()).matches(request)).findAny();
            if (any.isPresent()) {
                return Lists.newArrayList((Object[])new ConfigAttribute[]{PlatformConsts.METHOD_HAS_NO_PERM});
            }
            return null;
        }
        List<SysAuthResource> matchResourceList = sysAuthResourceList.stream().filter(f -> {
            boolean flag = f.getMenuAlias().equals(menuAlias) && new AntPathRequestMatcher(f.getMethodRequestUrl()).matches(request);
            return flag;
        }).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(matchResourceList)) {
            if (matchResourceList.stream().filter(f -> "1".equals(f.getFollowMenu())).findFirst().isPresent()) {
                return null;
            }
            ArrayList<ConfigAttribute> cfgAttrList = new ArrayList<ConfigAttribute>();
            matchResourceList.forEach(mrl -> {
                if (BeanUtils.isNotEmpty(mrl.getRoleAliasList())) {
                    mrl.getRoleAliasList().forEach(r -> cfgAttrList.add((ConfigAttribute)new SecurityConfig(r)));
                }
            });
            if (BeanUtils.isEmpty(cfgAttrList)) {
                return Lists.newArrayList((Object[])new ConfigAttribute[]{PlatformConsts.METHOD_HAS_NO_PERM});
            }
            return cfgAttrList;
        }
        return null;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return Collections.emptyList();
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    private static List<SysAuthResource> getMapThreadLocal() {
        List<SysAuthResource> authResources = mapThreadLocal.get();
        if (BeanUtils.isEmpty(authResources)) {
            authResources = new ArrayList<SysAuthResource>();
            mapThreadLocal.set(authResources);
        }
        return authResources;
    }

    private static void setMapThreadLocal(List<SysAuthResource> list) {
        mapThreadLocal.set(list);
    }

    public static void clearMapThreadLocal() {
        List<SysAuthResource> hashMap = mapThreadLocal.get();
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public void cleanAll() {
        HtInvocationSecurityMetadataSourceService.clearMapThreadLocal();
    }

    static {
        excludeUrls.add("/api/user/v1/user/updateUserPsw");
    }
}

