/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.service.impl;

import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.jwt.JwtAuthenticationResponse;
import com.hotent.base.service.TwoVerifyService;
import com.hotent.base.util.GoogleAuthenticator;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.TwoVerifyConfigVo;
import com.hotent.base.vo.TwoVerifyInfoVo;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TwoVerifyServiceImpl
implements TwoVerifyService {
    @Autowired
    PortalFeignService portalFeignService;

    @Override
    public TwoVerifyConfigVo getTwoVerifyConfig() {
        TwoVerifyConfigVo twoVerifyConfigVo = new TwoVerifyConfigVo();
        try {
            String twoVerifyConf = this.portalFeignService.getPropertyByAlias("twoVerifyConf");
            String baseUrl = this.portalFeignService.getPropertyByAlias("baseUrl");
            if (StringUtil.isNotEmpty(twoVerifyConf)) {
                twoVerifyConfigVo.setForceTwoVerify(Boolean.parseBoolean(twoVerifyConf));
            } else {
                twoVerifyConfigVo.setForceTwoVerify(false);
            }
            if (StringUtil.isNotEmpty(baseUrl)) {
                twoVerifyConfigVo.setHost(baseUrl.substring(baseUrl.lastIndexOf("/") + 1).split(":")[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (twoVerifyConfigVo.getForceTwoVerify() == null) {
            twoVerifyConfigVo.setForceTwoVerify(false);
        }
        return twoVerifyConfigVo;
    }

    @Override
    @CachePut(value={"eip:uc:userTempToken"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=180, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=180, preloadTime=36, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public JwtAuthenticationResponse putTempTokenInCache(String key, JwtAuthenticationResponse jwtAuthenticationResponse) {
        return jwtAuthenticationResponse;
    }

    @Override
    @Cacheable(value={"eip:uc:userTempToken"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=180, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=180, preloadTime=36, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public JwtAuthenticationResponse getTempTokenFromCache(String key) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:uc:userTempToken"}, key="#key", ignoreException=false)
    public void removeTempTokenFromCache(String key) {
    }

    @Override
    @CachePut(value={"eip:uc:twoVerifyErrorCount"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=180, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=180, preloadTime=36, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public int putTwoVerifyErrorCountInCache(String key, int errorCount) {
        return errorCount;
    }

    @Override
    @Cacheable(value={"eip:uc:twoVerifyErrorCount"}, key="#key", ignoreException=false, firstCache=@FirstCache(expireTime=180, timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=180, preloadTime=36, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public int getTwoVerifyErrorCountFromCache(String key) {
        return 0;
    }

    @Override
    @CacheEvict(value={"eip:uc:twoVerifyErrorCount"}, key="#key", ignoreException=false)
    public void removeTwoVerifyErrorCountFromCache(String key) {
    }

    @Override
    public TwoVerifyInfoVo initTwoVerifyInfo(String userName, String secret) {
        String host = this.getTwoVerifyConfig().getHost();
        TwoVerifyInfoVo twoVerifyInfoVo = new TwoVerifyInfoVo();
        twoVerifyInfoVo.setUsername(userName);
        twoVerifyInfoVo.setHost(host);
        if (StringUtil.isEmpty(secret)) {
            secret = GoogleAuthenticator.generateSecretKey();
        }
        twoVerifyInfoVo.setBindLink(GoogleAuthenticator.getQRBarcodeURL(userName, secret, host));
        twoVerifyInfoVo.setSecret(secret);
        return twoVerifyInfoVo;
    }
}

