/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.tenant;

import com.google.common.base.Joiner;
import com.hotent.base.tenant.ITenantInitHandler;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractTenantInitHandler
implements ITenantInitHandler {
    @Resource
    protected JdbcTemplate jdbcTemplate;

    protected abstract String getSql();

    @Override
    public void handle(String tenantId) {
        String sql = this.getSql();
        List queryForList = this.jdbcTemplate.queryForList(sql);
        ArrayList<String> updateSqlList = new ArrayList<String>();
        for (Map map : queryForList) {
            Iterator iter = map.entrySet().iterator();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList params = new ArrayList();
            Object id = null;
            while (iter.hasNext()) {
                String lowerCase;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                switch (lowerCase = key.toLowerCase()) {
                    case "id_": 
                    case "id": {
                        value = UniqueIdUtil.getSuid();
                        id = value;
                        break;
                    }
                    case "tenant_id_": {
                        value = tenantId;
                        break;
                    }
                    case "path_": {
                        if ("portal_news_tree_".equals(this.tableName())) {
                            value = String.valueOf(value).split("\\.")[0] + ".";
                            break;
                        }
                        value = String.valueOf(value).split("\\.")[0] + "." + id + ".";
                        break;
                    }
                }
                if (!BeanUtils.isNotEmpty(value) || value instanceof Date || value instanceof LocalDateTime) continue;
                fields.add(key);
                if (value instanceof String) {
                    value = "'" + value + "'";
                }
                if (value instanceof byte[]) {
                    value = "?";
                }
                params.add(value);
            }
            String updateSql = String.format("insert into %s(%s) values(%s)", this.tableName(), Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
            updateSqlList.add(updateSql);
        }
        for (String insertSql : updateSqlList) {
            this.jdbcTemplate.update(insertSql);
        }
    }
}

