/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.transaction;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.TransactionThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import org.springframework.context.ApplicationContext;

class ConnectionProxy
implements InvocationHandler {
    private static final String COMMIT = "commit";
    private static final String ROLLBACK = "rollback";
    private static final String CLOSE = "close";
    Connection connection;

    public ConnectionProxy(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        TransactionThreadLocal transactionThreadLocal;
        String methodName = method.getName();
        Object invoke = method.invoke((Object)this.connection, args);
        if (COMMIT.equals(methodName) && (transactionThreadLocal = this.getTransactionThreadLocal()) != null) {
            transactionThreadLocal.commit();
        }
        if (ROLLBACK.equals(methodName) && (transactionThreadLocal = this.getTransactionThreadLocal()) != null) {
            transactionThreadLocal.rollback();
        }
        if (CLOSE.equals(methodName) && (transactionThreadLocal = this.getTransactionThreadLocal()) != null) {
            transactionThreadLocal.close();
        }
        return invoke;
    }

    private TransactionThreadLocal getTransactionThreadLocal() {
        ApplicationContext applicaitonContext = AppUtil.getApplicaitonContext();
        if (applicaitonContext != null && applicaitonContext.containsBean("transactionThreadLocal")) {
            return (TransactionThreadLocal)applicaitonContext.getBean(TransactionThreadLocal.class);
        }
        return null;
    }
}

