/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.typehandle;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import io.jsonwebtoken.lang.Collections;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ListToVarcharTypeHandle
extends BaseTypeHandler<Collection<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, Collection<String> parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setString(i, null);
        } else {
            Collection collect = parameter.stream().filter(BeanUtils::isNotEmpty).map(String::valueOf).collect(Collectors.toList());
            String join = StringUtil.join(collect, ",");
            ps.setString(i, join);
        }
    }

    public Collection<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object data = rs.getObject(columnName);
        return this.handleResult(data);
    }

    public Collection<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object data = rs.getObject(columnIndex);
        return this.handleResult(data);
    }

    public Collection<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object data = cs.getObject(columnIndex);
        return this.handleResult(data);
    }

    private Collection<String> handleResult(Object data) {
        if (BeanUtils.isEmpty(data)) {
            return null;
        }
        if (data instanceof Clob) {
            try {
                return Collections.arrayToList((Object)SQLUtil.ClobToString((Clob)data).split(","));
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        return Collections.arrayToList((Object)data.toString().split(","));
    }
}

