/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationUtil
implements ContextThread {
    public static final String CURRENT_USER_MAIN_ORGID = "CURRENT_USER_MAIN_ORGID";
    public static final String CURRENT_USER_MAIN_ORGCODE = "CURRENT_USER_MAIN_ORGCODE";
    public static final String CURRENT_USER_MAIN_ORGNAME = "CURRENT_USER_MAIN_ORGNAME";
    public static final String CURRENT_USER_ORGIDS = "CURRENT_USER_ORGIDS";
    public static final String CURRENT_USER_SUB_ORGIDS = "CURRENT_USER_SUB_ORGIDS";
    private static ThreadLocal<JsonNode> userThreadLocal = new ThreadLocal();
    private static ThreadLocal<Authentication> authenticationThreadLocal = new ThreadLocal();
    private static ThreadLocal<String[]> msIdsThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> mapThreadLocal = new ThreadLocal();

    public static void setMapThreadLocal(Map<String, Object> map) {
        mapThreadLocal.set(map);
    }

    public static Map<String, Object> getMapThreadLocal() {
        Map<String, Object> resultMap = mapThreadLocal.get();
        if (BeanUtils.isEmpty(resultMap)) {
            resultMap = new HashMap<String, Object>();
        }
        return resultMap;
    }

    public static void removeMapThreadLocal() {
        mapThreadLocal.remove();
    }

    public static void setMsIdsThreadLocal(String[] msIds) {
        msIdsThreadLocal.set(msIds);
    }

    public static String[] getMsIdsThreadLocal() {
        return msIdsThreadLocal.get();
    }

    public static void removeMsIdsThreadLocal() {
        msIdsThreadLocal.remove();
    }

    public static JsonNode getUserThreadLocal() {
        JsonNode jsonNode = userThreadLocal.get();
        if (BeanUtils.isEmpty(jsonNode)) {
            return JsonUtil.getMapper().createObjectNode();
        }
        return jsonNode;
    }

    public static void setAuthentication(Authentication authentication) {
        authenticationThreadLocal.set(authentication);
        Object principal = authentication.getPrincipal();
        try {
            if (principal instanceof UserDetails) {
                UserDetails ud = (UserDetails)principal;
                String json = JsonUtil.toJson(ud);
                JsonNode jsonNode = JsonUtil.toJsonNode(json);
                userThreadLocal.set(jsonNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getCurrentUserId() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("userId");
        if (BeanUtils.isEmpty(jsonNode) || !jsonNode.isTextual()) {
            return null;
        }
        return jsonNode.asText();
    }

    public static String getCurrentUserFullname() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("fullname");
        if (BeanUtils.isEmpty(jsonNode) || !jsonNode.isTextual()) {
            return null;
        }
        return jsonNode.asText();
    }

    public static String getCurrentUsername() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("account");
        if (BeanUtils.isEmpty(jsonNode) || !jsonNode.isTextual()) {
            return null;
        }
        return jsonNode.asText();
    }

    public static String getCurrentUserMainOrgId() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("attributes");
        if (BeanUtils.isNotEmpty(jsonNode) && jsonNode.has(CURRENT_USER_MAIN_ORGID)) {
            return jsonNode.get(CURRENT_USER_MAIN_ORGID).asText();
        }
        return null;
    }

    public static String getCurrentUserOrgIds() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("attributes");
        if (BeanUtils.isNotEmpty(jsonNode) && jsonNode.has(CURRENT_USER_ORGIDS)) {
            return jsonNode.get(CURRENT_USER_ORGIDS).asText();
        }
        return null;
    }

    public static String getCurrentUserSubOrgIds() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("attributes");
        if (BeanUtils.isNotEmpty(jsonNode) && jsonNode.has(CURRENT_USER_SUB_ORGIDS)) {
            return jsonNode.get(CURRENT_USER_SUB_ORGIDS).asText();
        }
        return null;
    }

    public static Set<String> getCurrentUserRolesAlias() {
        Authentication authentication = authenticationThreadLocal.get();
        HashSet<String> set = new HashSet<String>();
        if (BeanUtils.isEmpty(authentication)) {
            return set;
        }
        Collection authorities = authentication.getAuthorities();
        for (SimpleGrantedAuthority simpleGrantedAuthority : authorities) {
            set.add(simpleGrantedAuthority.getAuthority());
        }
        return set;
    }

    public static void removeAll() {
        userThreadLocal.remove();
        authenticationThreadLocal.remove();
        msIdsThreadLocal.remove();
        mapThreadLocal.remove();
    }

    public static boolean isAnonymous(Authentication authentication) {
        if (BeanUtils.isEmpty(authentication)) {
            return true;
        }
        return authentication instanceof AnonymousAuthenticationToken;
    }

    @Override
    public void cleanAll() {
        AuthenticationUtil.removeAll();
    }

    public static void setAuthentication(Authentication authentication, String sysCode, String sysName) {
        authenticationThreadLocal.set(authentication);
        Object principal = authentication.getPrincipal();
        try {
            if (principal instanceof UserDetails) {
                UserDetails ud = (UserDetails)principal;
                String json = JsonUtil.toJson(ud);
                JsonNode jsonNode = JsonUtil.toJsonNode(json);
                if (StringUtil.isNotEmpty(sysCode) && jsonNode instanceof ObjectNode) {
                    ((ObjectNode)jsonNode).put("sysCode", sysCode);
                }
                if (StringUtil.isNotEmpty(sysName) && jsonNode instanceof ObjectNode) {
                    ((ObjectNode)jsonNode).put("sysName", sysName);
                }
                userThreadLocal.set(jsonNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getSysCode() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("sysCode");
        if (BeanUtils.isEmpty(jsonNode) || !jsonNode.isTextual()) {
            return null;
        }
        return jsonNode.asText();
    }

    public static String getSysName() {
        JsonNode jsonNode = AuthenticationUtil.getUserThreadLocal().get("sysName");
        if (BeanUtils.isEmpty(jsonNode) || !jsonNode.isTextual()) {
            return null;
        }
        return jsonNode.asText();
    }
}

