/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BaseContextThreadUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.util.IPermissionCalc;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DataDesensiUtil {
    public static ObjectNode hanlerDataDesensitize(ObjectNode jsondata, String permission, boolean isMobile) throws IOException {
        if (StringUtil.isEmpty(permission)) {
            return jsondata;
        }
        JsonNode permissionNode = JsonUtil.toJsonNode(permission);
        if (BeanUtils.isNotEmpty(jsondata) && permissionNode.hasNonNull("desensitization")) {
            Map<String, Object> desensiMap;
            JsonNode desensiNode = permissionNode.get("desensitization");
            HashSet<String> desensiIds = new HashSet<String>();
            Iterator iterator = desensiNode.fields();
            HashMap<String, String> desensiFieldPath = new HashMap<String, String>();
            IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
            Map currentProfiles = permissionCalc.getCurrentProfiles();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                JsonNode tableJson = (JsonNode)entry.getValue();
                Iterator tableIterator = tableJson.fields();
                while (tableIterator.hasNext()) {
                    Map.Entry fieldJson = (Map.Entry)tableIterator.next();
                    JsonNode fieldJsonNode = (JsonNode)fieldJson.getValue();
                    String desensiId = "";
                    if (!isMobile && fieldJsonNode.hasNonNull("pc")) {
                        desensiId = fieldJsonNode.get("pc").asText();
                        desensiIds.add(desensiId);
                    }
                    if (isMobile && fieldJsonNode.hasNonNull("mobile")) {
                        desensiId = fieldJsonNode.get("mobile").asText();
                        desensiIds.add(desensiId);
                    }
                    if (!StringUtil.isNotEmpty(desensiId)) continue;
                    desensiFieldPath.put(String.format("%s.%s", entry.getKey(), fieldJson.getKey()), desensiId);
                }
            }
            if (!desensiIds.isEmpty() && !(desensiMap = DataDesensiUtil.getDesensiMap(desensiIds.stream().collect(Collectors.toList()))).isEmpty()) {
                FormFeignService formFeignService = AppUtil.getBean(FormFeignService.class);
                Iterator dataIterator = jsondata.fields();
                while (dataIterator.hasNext()) {
                    ObjectNode ywdxObj;
                    String key;
                    Map.Entry next = (Map.Entry)dataIterator.next();
                    String mainTableCode = key = (String)next.getKey();
                    CommonResult<String> boResult = formFeignService.getMainTableAliasByBoCode(key);
                    if (BeanUtils.isNotEmpty(boResult) && boResult.getState().booleanValue()) {
                        mainTableCode = boResult.getValue();
                    }
                    if (!BeanUtils.isNotEmpty(ywdxObj = (ObjectNode)next.getValue())) continue;
                    Iterator fieldIterator = ywdxObj.fields();
                    while (fieldIterator.hasNext()) {
                        Map.Entry mainNext = (Map.Entry)fieldIterator.next();
                        String fieldName = (String)mainNext.getKey();
                        String mainDesensiKey = String.format("%s.%s", mainTableCode, fieldName);
                        if (fieldName.contains("sub_") && mainNext.getValue() instanceof ArrayNode) {
                            String subFieldKey = fieldName.replace("sub_", "");
                            ArrayNode subArrayObj = (ArrayNode)mainNext.getValue();
                            if (!BeanUtils.isNotEmpty(subArrayObj)) continue;
                            for (JsonNode subNode : subArrayObj) {
                                Iterator subIterator = subNode.fields();
                                while (subIterator.hasNext()) {
                                    Map.Entry subNext = (Map.Entry)subIterator.next();
                                    String subFieldName = (String)subNext.getKey();
                                    String subDesensiKey = String.format("%s.%s", subFieldKey, subFieldName);
                                    if (subFieldName.contains("sub_") && subNext.getValue() instanceof ArrayNode) {
                                        String sunFieldKey = subFieldName.replace("sub_", "");
                                        ArrayNode sunArrayObj = (ArrayNode)subNext.getValue();
                                        if (!BeanUtils.isNotEmpty(sunArrayObj)) continue;
                                        for (JsonNode sunNode : sunArrayObj) {
                                            Iterator sunIterator = sunNode.fields();
                                            while (sunIterator.hasNext()) {
                                                Map.Entry sunNext = (Map.Entry)sunIterator.next();
                                                String sunFieldName = (String)sunNext.getKey();
                                                String sunDesensiKey = String.format("%s.%s", sunFieldKey, sunFieldName);
                                                if (!desensiFieldPath.containsKey(sunDesensiKey)) continue;
                                                DataDesensiUtil.desensiFieldValue(desensiMap, desensiFieldPath, currentProfiles, (ObjectNode)sunNode, sunFieldName, sunNext.getValue(), sunDesensiKey);
                                            }
                                        }
                                        continue;
                                    }
                                    if (!desensiFieldPath.containsKey(subDesensiKey)) continue;
                                    DataDesensiUtil.desensiFieldValue(desensiMap, desensiFieldPath, currentProfiles, (ObjectNode)subNode, subFieldName, subNext.getValue(), subDesensiKey);
                                }
                            }
                            continue;
                        }
                        if (!desensiFieldPath.containsKey(mainDesensiKey)) continue;
                        DataDesensiUtil.desensiFieldValue(desensiMap, desensiFieldPath, currentProfiles, ywdxObj, fieldName, mainNext.getValue(), mainDesensiKey);
                    }
                }
            }
        }
        return jsondata;
    }

    private static void desensiFieldValue(Map<String, Object> desensiMap, Map<String, String> desensiFieldPath, Map<String, Set<String>> currentProfiles, ObjectNode obj, String fieldName, Object value, String desensiKey) throws IOException {
        JsonNode desensiObj = (JsonNode)desensiMap.get(desensiFieldPath.get(desensiKey));
        boolean hasRight = DataDesensiUtil.hasRight(desensiObj.get("rights").asText(), currentProfiles);
        if (!hasRight && BeanUtils.isNotEmpty(value)) {
            Object desensiValue = DataDesensiUtil.handleField(value, desensiObj);
            obj.put(fieldName, String.valueOf(desensiValue));
        }
    }

    private static Map<String, Object> getDesensiMap(List<String> ids) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PortalFeignService feignService = AppUtil.getBean(PortalFeignService.class);
        List<Object> list = feignService.getDesensiRulesByIds(ids);
        if (BeanUtils.isNotEmpty(list)) {
            list.forEach(item -> {
                try {
                    JsonNode node = JsonUtil.toJsonNode(item);
                    map.put(node.get("id").asText(), node);
                }
                catch (IOException e) {
                    throw new WorkFlowException(e.getMessage());
                }
            });
        }
        return map;
    }

    private static Object handleField(Object value, JsonNode desensiObj) throws IOException {
        Object workMask = value;
        String type = JsonUtil.getString(desensiObj, "type", "1");
        String groovyScript = JsonUtil.getString(desensiObj, "groovyScript", "");
        GroovyScriptEngine groovyScriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
        if (StringUtil.isNotEmpty(groovyScript) && "2".equals(type)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            workMask = groovyScriptEngine.executeObject(groovyScript, vars);
        } else if ("1".equals(type)) {
            int maxLength = 0;
            if (!(value instanceof String) && !(value instanceof TextNode)) {
                value = TextNode.valueOf((String)value.toString());
            }
            if (BeanUtils.isNotEmpty(value)) {
                int endPosition;
                String valueStr = "";
                if (value instanceof TextNode) {
                    TextNode valueNode = (TextNode)value;
                    valueStr = valueNode.asText();
                } else {
                    valueStr = String.valueOf(value);
                }
                maxLength = valueStr.length();
                int startPosition = desensiObj.get("startPosition").asInt(0);
                if (startPosition > maxLength) {
                    startPosition = maxLength;
                }
                if ((endPosition = desensiObj.get("endPosition").asInt(maxLength)) > maxLength) {
                    endPosition = maxLength;
                }
                String pad = desensiObj.get("pad").asText("*");
                workMask = StringUtil.wordMask(valueStr, startPosition, endPosition, pad);
            }
        }
        return workMask;
    }

    private static boolean hasRight(String rights, Map<String, Set<String>> currentProfiles) throws IOException {
        IPermissionCalc permissionCalc = AppUtil.getBean(IPermissionCalc.class);
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(rights);
        if (arrayNode.isEmpty()) {
            return false;
        }
        return permissionCalc.hasRight(JsonUtil.toJsonString(arrayNode.get(0)), currentProfiles);
    }

    public static void hanlerDesensitizeSettings(String desensitization, String formType) throws IOException {
        if (BeanUtils.isNotEmpty(desensitization)) {
            BaseContextThreadUtil.putCommonVars("desensitization", desensitization);
            BaseContextThreadUtil.putCommonVars("formType", formType);
            JsonNode desensiNode = JsonUtil.toJsonNode(desensitization);
            HashSet<String> desensiIds = new HashSet<String>();
            Iterator iterator = desensiNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                JsonNode tableJson = (JsonNode)entry.getValue();
                Iterator tableIterator = tableJson.fields();
                while (tableIterator.hasNext()) {
                    Map.Entry fieldJson = (Map.Entry)tableIterator.next();
                    JsonNode fieldJsonNode = (JsonNode)fieldJson.getValue();
                    if (!fieldJsonNode.hasNonNull(formType)) continue;
                    desensiIds.add(fieldJsonNode.get(formType).asText());
                }
            }
            if (!desensiIds.isEmpty()) {
                Map<String, Object> desensiRuleMap = DataDesensiUtil.getDesensiMap(desensiIds.stream().collect(Collectors.toList()));
                BaseContextThreadUtil.putCommonVars("desensiRule", desensiRuleMap);
            }
        }
    }
}

