/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.function.DesensitizationFunction;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.DesensitizeUtil;
import com.hotent.base.util.StringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesensitizeRegexUtil {
    private static final String FILLING = "*";
    public static final String ID_CARD_NUMBER_REGEX = "([1-9]\\d{5}(?:18|19|20|(?:3\\d))\\d{2}(?:(?:0[1-9])|(?:1[0-2]))(?:(?:[0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx])";
    public static final String ID_CARD_NUMBER_REGEX_3 = "([1-9]\\d{5}(?:18|19|20|(?:3\\d))\\d{2}(?:0[1-9])|(?:1[0-2]))((?:[0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]";
    public static final String ID_CARD_NUMBER_REGEX_2 = "\\d{17}[0-9Xx]";
    public static final String PASSPORT_NUMBER_REGEX = "(1[45][0-9]{7}|(?:[P|p|S|s]\\d{7})|(?:[S|s|G|g]\\d{8})|(?:[Gg|Tt|Ss|Ll|Qq|Dd|Aa|Ff]\\d{8})|(?:[H|h|M|m]\\d{8,10}))";
    public static final String LICENSE_PLATE_NUMBER_REGEX = "(^[\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0][ABCDEFGHJKLMNPQRSTUVWXY][1-9DF][1-9ABCDEFGHJKLMNPQRSTUVWXYZ]\\d{3}[1-9DF])|([\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0][ABCDEFGHJKLMNPQRSTUVWXY]\\dABCDEFGHJKLNMxPQRSTUVWXYZ)";
    public static final String LICENSE_PLATE_NUMBER_REGEX2 = "[\\u4e00-\\u9fa5]{1}[A-Z]{1}[A-Z0-9]{5}";
    public static final String LICENSE_PLATE_NUMBER_REGEX3 = "[\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0][A-HJ-NP-Z]{1}[A-HJ-NP-Z0-9]{5,6}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3]{1}";
    public static final String PHONE_NUMBER_REGEX = "((?:13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8})";
    public static final String FAX_NUMBER_REGEX = "(?:(?:0[0-9]{2,3}-)(?:[2-9][0-9]{6,7})+(?:-[0-9]{1,4})?)";
    public static final String FAX_NUMBER_REGEX2 = "(0[0-9]{2,3})-(\\d{7,8})-?(\\d{1,4})?";
    public static final String EMAIL_REGEX = "(\\w+([-+.]\\w+)@\\w+([-.]\\w+)\\.\\w+([-.]w+)*)";
    public static final String BANK_CARD_NUMBER_REGEX = "([1-9]{1})(\\d{14}|\\d{18})";
    public static final String BANK_CARD_NUMBER_REGEX2 = "\\d{16,19}";
    public static final String PROVINCE_REGEX = "\u6cb3\u5317\u7701|\u5c71\u897f\u7701|\u8fbd\u5b81\u7701|\u5409\u6797\u7701|\u9ed1\u9f99\u6c5f\u7701|\u6c5f\u82cf\u7701|\u6d59\u6c5f\u7701|\u5b89\u5fbd\u7701|\u798f\u5efa\u7701|\u6c5f\u897f\u7701|\u5c71\u4e1c\u7701|\u6cb3\u5357\u7701|\u6e56\u5317\u7701|\u6e56\u5357\u7701|\u5e7f\u4e1c\u7701|\u6d77\u5357\u7701|\u56db\u5ddd\u7701|\u8d35\u5dde\u7701|\u4e91\u5357\u7701|\u9655\u897f\u7701|\u7518\u8083\u7701|\u9752\u6d77\u7701|\u53f0\u6e7e\u7701";
    public static final String CITY_ADDRESS_REGEX = "\u5317\u4eac\u5e02|\u5929\u6d25\u5e02|\u4e0a\u6d77\u5e02|\u91cd\u5e86\u5e02|\u77f3\u5bb6\u5e84\u5e02|\u5510\u5c71\u5e02|\u79e6\u7687\u5c9b\u5e02|\u90af\u90f8\u5e02|\u90a2\u53f0\u5e02|\u4fdd\u5b9a\u5e02|\u5f20\u5bb6\u53e3\u5e02|\u627f\u5fb7\u5e02|\u6ca7\u5dde\u5e02|\u5eca\u574a\u5e02|\u8861\u6c34\u5e02|\u592a\u539f\u5e02|\u5927\u540c\u5e02|\u9633\u6cc9\u5e02|\u957f\u6cbb\u5e02|\u664b\u57ce\u5e02|\u6714\u5dde\u5e02|\u664b\u4e2d\u5e02|\u8fd0\u57ce\u5e02|\u5ffb\u5dde\u5e02|\u4e34\u6c7e\u5e02|\u5415\u6881\u5e02|\u547c\u548c\u6d69\u7279\u5e02|\u5305\u5934\u5e02|\u4e4c\u6d77\u5e02|\u8d64\u5cf0\u5e02|\u901a\u8fbd\u5e02|\u9102\u5c14\u591a\u65af\u5e02|\u547c\u4f26\u8d1d\u5c14\u5e02|\u5df4\u5f66\u6dd6\u5c14\u5e02|\u4e4c\u5170\u5bdf\u5e03\u5e02|\u6c88\u9633\u5e02|\u5927\u8fde\u5e02|\u978d\u5c71\u5e02|\u629a\u987a\u5e02|\u672c\u6eaa\u5e02|\u4e39\u4e1c\u5e02|\u9526\u5dde\u5e02|\u8425\u53e3\u5e02|\u961c\u65b0\u5e02|\u8fbd\u9633\u5e02|\u76d8\u9526\u5e02|\u94c1\u5cad\u5e02|\u671d\u9633\u5e02|\u846b\u82a6\u5c9b\u5e02|\u957f\u6625\u5e02|\u5409\u6797\u5e02|\u56db\u5e73\u5e02|\u8fbd\u6e90\u5e02|\u901a\u5316\u5e02|\u767d\u5c71\u5e02|\u677e\u539f\u5e02|\u767d\u57ce\u5e02|\u54c8\u5c14\u6ee8\u5e02|\u9f50\u9f50\u54c8\u5c14\u5e02|\u9e21\u897f\u5e02|\u9e64\u5c97\u5e02|\u53cc\u9e2d\u5c71\u5e02|\u5927\u5e86\u5e02|\u4f0a\u6625\u5e02|\u4f73\u6728\u65af\u5e02|\u4e03\u53f0\u6cb3\u5e02|\u7261\u4e39\u6c5f\u5e02|\u9ed1\u6cb3\u5e02|\u7ee5\u5316\u5e02|\u5357\u4eac\u5e02|\u65e0\u9521\u5e02|\u5f90\u5dde\u5e02|\u5e38\u5dde\u5e02|\u82cf\u5dde\u5e02|\u5357\u901a\u5e02|\u8fde\u4e91\u6e2f\u5e02|\u6dee\u5b89\u5e02|\u76d0\u57ce\u5e02|\u626c\u5dde\u5e02|\u9547\u6c5f\u5e02|\u6cf0\u5dde\u5e02|\u5bbf\u8fc1\u5e02|\u676d\u5dde\u5e02|\u5b81\u6ce2\u5e02|\u6e29\u5dde\u5e02|\u5609\u5174\u5e02|\u6e56\u5dde\u5e02|\u7ecd\u5174\u5e02|\u91d1\u534e\u5e02|\u8862\u5dde\u5e02|\u821f\u5c71\u5e02|\u53f0\u5dde\u5e02|\u4e3d\u6c34\u5e02|\u5408\u80a5\u5e02|\u829c\u6e56\u5e02|\u868c\u57e0\u5e02|\u6dee\u5357\u5e02|\u9a6c\u978d\u5c71\u5e02|\u6dee\u5317\u5e02|\u94dc\u9675\u5e02|\u5b89\u5e86\u5e02|\u9ec4\u5c71\u5e02|\u961c\u9633\u5e02|\u5bbf\u5dde\u5e02|\u6ec1\u5dde\u5e02|\u516d\u5b89\u5e02|\u5ba3\u57ce\u5e02|\u6c60\u5dde\u5e02|\u4eb3\u5dde\u5e02|\u798f\u5dde\u5e02|\u53a6\u95e8\u5e02|\u8386\u7530\u5e02|\u4e09\u660e\u5e02|\u6cc9\u5dde\u5e02|\u6f33\u5dde\u5e02|\u5357\u5e73\u5e02|\u9f99\u5ca9\u5e02|\u5b81\u5fb7\u5e02|\u5357\u660c\u5e02|\u666f\u5fb7\u9547\u5e02|\u840d\u4e61\u5e02|\u4e5d\u6c5f\u5e02|\u629a\u5dde\u5e02|\u9e70\u6f6d\u5e02|\u8d63\u5dde\u5e02|\u5409\u5b89\u5e02|\u5b9c\u6625\u5e02|\u65b0\u4f59\u5e02|\u4e0a\u9976\u5e02|\u6d4e\u5357\u5e02|\u9752\u5c9b\u5e02|\u6dc4\u535a\u5e02|\u67a3\u5e84\u5e02|\u4e1c\u8425\u5e02|\u70df\u53f0\u5e02|\u6f4d\u574a\u5e02|\u6d4e\u5b81\u5e02|\u6cf0\u5b89\u5e02|\u5a01\u6d77\u5e02|\u65e5\u7167\u5e02|\u4e34\u6c82\u5e02|\u5fb7\u5dde\u5e02|\u804a\u57ce\u5e02|\u6ee8\u5dde\u5e02|\u83cf\u6cfd\u5e02|\u90d1\u5dde\u5e02|\u5f00\u5c01\u5e02|\u6d1b\u9633\u5e02|\u5e73\u9876\u5c71\u5e02|\u5b89\u9633\u5e02|\u9e64\u58c1\u5e02|\u65b0\u4e61\u5e02|\u7126\u4f5c\u5e02|\u6fee\u9633\u5e02|\u8bb8\u660c\u5e02|\u6f2f\u6cb3\u5e02|\u4e09\u95e8\u5ce1\u5e02|\u5357\u9633\u5e02|\u5546\u4e18\u5e02|\u4fe1\u9633\u5e02|\u5468\u53e3\u5e02|\u9a7b\u9a6c\u5e97\u5e02|\u6b66\u6c49\u5e02|\u9ec4\u77f3\u5e02|\u5341\u5830\u5e02|\u5b9c\u660c\u5e02|\u8944\u9633\u5e02|\u9102\u5dde\u5e02|\u8346\u95e8\u5e02|\u5b5d\u611f\u5e02|\u8346\u5dde\u5e02|\u9ec4\u5188\u5e02|\u54b8\u5b81\u5e02|\u968f\u5dde\u5e02|\u957f\u6c99\u5e02|\u682a\u6d32\u5e02|\u6e58\u6f6d\u5e02|\u8861\u9633\u5e02|\u90b5\u9633\u5e02|\u5cb3\u9633\u5e02|\u5e38\u5fb7\u5e02|\u5f20\u5bb6\u754c\u5e02|\u76ca\u9633\u5e02|\u90f4\u5dde\u5e02|\u6c38\u5dde\u5e02|\u6000\u5316\u5e02|\u5a04\u5e95\u5e02|\u5e7f\u5dde\u5e02|\u97f6\u5173\u5e02|\u6df1\u5733\u5e02|\u73e0\u6d77\u5e02|\u6c55\u5934\u5e02|\u4f5b\u5c71\u5e02|\u6c5f\u95e8\u5e02|\u6e5b\u6c5f\u5e02|\u8302\u540d\u5e02|\u8087\u5e86\u5e02|\u60e0\u5dde\u5e02|\u6885\u5dde\u5e02|\u6c55\u5c3e\u5e02|\u6cb3\u6e90\u5e02|\u9633\u6c5f\u5e02|\u6e05\u8fdc\u5e02|\u4e1c\u839e\u5e02|\u4e2d\u5c71\u5e02|\u6f6e\u5dde\u5e02|\u63ed\u9633\u5e02|\u4e91\u6d6e\u5e02|\u5357\u5b81\u5e02|\u67f3\u5dde\u5e02|\u6842\u6797\u5e02|\u68a7\u5dde\u5e02|\u5317\u6d77\u5e02|\u9632\u57ce\u6e2f\u5e02|\u94a6\u5dde\u5e02|\u8d35\u6e2f\u5e02|\u7389\u6797\u5e02|\u767e\u8272\u5e02|\u8d3a\u5dde\u5e02|\u6cb3\u6c60\u5e02|\u6765\u5bbe\u5e02|\u5d07\u5de6\u5e02|\u6d77\u53e3\u5e02|\u4e09\u4e9a\u5e02|\u4e09\u6c99\u5e02|\u510b\u5dde\u5e02|\u6210\u90fd\u5e02|\u81ea\u8d21\u5e02|\u6500\u679d\u82b1\u5e02|\u6cf8\u5dde\u5e02|\u5fb7\u9633\u5e02|\u7ef5\u9633\u5e02|\u5e7f\u5143\u5e02|\u9042\u5b81\u5e02|\u5185\u6c5f\u5e02|\u4e50\u5c71\u5e02|\u5357\u5145\u5e02|\u7709\u5c71\u5e02|\u5b9c\u5bbe\u5e02|\u5e7f\u5b89\u5e02|\u8fbe\u5dde\u5e02|\u96c5\u5b89\u5e02|\u5df4\u4e2d\u5e02|\u8d44\u9633\u5e02|\u8d35\u9633\u5e02|\u516d\u76d8\u6c34\u5e02|\u9075\u4e49\u5e02|\u5b89\u987a\u5e02|\u6bd5\u8282\u5e02|\u94dc\u4ec1\u5e02|\u6606\u660e\u5e02|\u66f2\u9756\u5e02|\u7389\u6eaa\u5e02|\u4fdd\u5c71\u5e02|\u662d\u901a\u5e02|\u4e3d\u6c5f\u5e02|\u666e\u6d31\u5e02|\u4e34\u6ca7\u5e02|\u62c9\u8428\u5e02|\u65e5\u5580\u5219\u5e02|\u660c\u90fd\u5e02|\u6797\u829d\u5e02|\u5c71\u5357\u5e02|\u90a3\u66f2\u5e02|\u897f\u5b89\u5e02|\u94dc\u5ddd\u5e02|\u5b9d\u9e21\u5e02|\u54b8\u9633\u5e02|\u6e2d\u5357\u5e02|\u5ef6\u5b89\u5e02|\u6c49\u4e2d\u5e02|\u6986\u6797\u5e02|\u5b89\u5eb7\u5e02|\u5546\u6d1b\u5e02|\u5170\u5dde\u5e02|\u5609\u5cea\u5173\u5e02|\u91d1\u660c\u5e02|\u767d\u94f6\u5e02|\u5929\u6c34\u5e02|\u6b66\u5a01\u5e02|\u5f20\u6396\u5e02|\u5e73\u51c9\u5e02|\u9152\u6cc9\u5e02|\u5e86\u9633\u5e02|\u5b9a\u897f\u5e02|\u9647\u5357\u5e02|\u897f\u5b81\u5e02|\u6d77\u4e1c\u5e02|\u94f6\u5ddd\u5e02|\u77f3\u5634\u5c71\u5e02|\u5434\u5fe0\u5e02|\u56fa\u539f\u5e02|\u4e2d\u536b\u5e02|\u4e4c\u9c81\u6728\u9f50\u5e02|\u514b\u62c9\u739b\u4f9d\u5e02|\u5410\u9c81\u756a\u5e02|\u54c8\u5bc6\u5e02|\u8f9b\u96c6\u5e02|\u85c1\u57ce\u5e02|\u664b\u5dde\u5e02|\u65b0\u4e50\u5e02|\u9e7f\u6cc9\u5e02|\u9075\u5316\u5e02|\u8fc1\u5b89\u5e02|\u6b66\u5b89\u5e02|\u5357\u5bab\u5e02|\u6c99\u6cb3\u5e02|\u6dbf\u5dde\u5e02|\u5b9a\u5dde\u5e02|\u5b89\u56fd\u5e02|\u9ad8\u7891\u5e97\u5e02|\u6cca\u5934\u5e02|\u4efb\u4e18\u5e02|\u9ec4\u9a85\u5e02|\u6cb3\u95f4\u5e02|\u9738\u5dde\u5e02|\u4e09\u6cb3\u5e02|\u5180\u5dde\u5e02|\u6df1\u5dde\u5e02|\u970d\u6797\u90ed\u52d2\u5e02|\u6ee1\u6d32\u91cc\u5e02|\u7259\u514b\u77f3\u5e02|\u624e\u5170\u5c6f\u5e02|\u6839\u6cb3\u5e02|\u989d\u5c14\u53e4\u7eb3\u5e02|\u4e30\u9547\u5e02|\u9521\u6797\u6d69\u7279\u5e02|\u4e8c\u8fde\u6d69\u7279\u5e02|\u4e4c\u5170\u6d69\u7279\u5e02|\u963f\u5c14\u5c71\u5e02|\u65b0\u6c11\u5e02|\u74e6\u623f\u5e97\u5e02|\u666e\u5170\u5e97\u5e02|\u5e84\u6cb3\u5e02|\u6d77\u57ce\u5e02|\u4e1c\u6e2f\u5e02|\u51e4\u57ce\u5e02|\u51cc\u6d77\u5e02|\u5317\u9547\u5e02|\u5927\u77f3\u6865\u5e02|\u76d6\u5dde\u5e02|\u706f\u5854\u5e02|\u8c03\u5175\u5c71\u5e02|\u5f00\u539f\u5e02|\u51cc\u6e90\u5e02|\u5317\u7968\u5e02|\u5174\u57ce\u5e02|\u4e5d\u53f0\u5e02|\u6986\u6811\u5e02|\u5fb7\u60e0\u5e02|\u8212\u5170\u5e02|\u6866\u7538\u5e02|\u86df\u6cb3\u5e02|\u78d0\u77f3\u5e02|\u516c\u4e3b\u5cad\u5e02|\u53cc\u8fbd\u5e02|\u6885\u6cb3\u53e3\u5e02|\u96c6\u5b89\u5e02|\u4e34\u6c5f\u5e02|\u5927\u5b89\u5e02|\u6d2e\u5357\u5e02|\u5ef6\u5409\u5e02|\u56fe\u4eec\u5e02|\u6566\u5316\u5e02|\u9f99\u4e95\u5e02|\u73f2\u6625\u5e02|\u548c\u9f99\u5e02|\u5c1a\u5fd7\u5e02|\u53cc\u57ce\u5e02|\u4e94\u5e38\u5e02|\u8bb7\u6cb3\u5e02|\u5bc6\u5c71\u5e02|\u864e\u6797\u5e02|\u94c1\u529b\u5e02|\u7ee5\u82ac\u6cb3\u5e02|\u5b81\u5b89\u5e02|\u6d77\u6797\u5e02|\u7a46\u68f1\u5e02|\u540c\u6c5f\u5e02|\u5bcc\u9526\u5e02|\u5317\u5b89\u5e02|\u4e94\u5927\u8fde\u6c60\u5e02|\u5b89\u8fbe\u5e02|\u8087\u4e1c\u5e02|\u6d77\u4f26\u5e02|\u6c5f\u9634\u5e02|\u5b9c\u5174\u5e02|\u90b3\u5dde\u5e02|\u65b0\u6c82\u5e02|\u91d1\u575b\u5e02|\u6ea7\u9633\u5e02|\u5e38\u719f\u5e02|\u5f20\u5bb6\u6e2f\u5e02|\u592a\u4ed3\u5e02|\u6606\u5c71\u5e02|\u5434\u6c5f\u5e02|\u5982\u768b\u5e02|\u901a\u5dde\u5e02|\u6d77\u95e8\u5e02|\u542f\u4e1c\u5e02|\u4e1c\u53f0\u5e02|\u5927\u4e30\u5e02|\u9ad8\u90ae\u5e02|\u6c5f\u90fd\u5e02|\u4eea\u5f81\u5e02|\u4e39\u9633\u5e02|\u626c\u4e2d\u5e02|\u53e5\u5bb9\u5e02|\u6cf0\u5174\u5e02|\u59dc\u5830\u5e02|\u9756\u6c5f\u5e02|\u5174\u5316\u5e02|\u5efa\u5fb7\u5e02|\u5bcc\u9633\u5e02|\u4e34\u5b89\u5e02|\u4f59\u59da\u5e02|\u6148\u6eaa\u5e02|\u5949\u5316\u5e02|\u745e\u5b89\u5e02|\u4e50\u6e05\u5e02|\u6d77\u5b81\u5e02|\u5e73\u6e56\u5e02|\u6850\u4e61\u5e02|\u8bf8\u66a8\u5e02|\u4e0a\u865e\u5e02|\u5d4a\u5dde\u5e02|\u5170\u6eaa\u5e02|\u4e49\u4e4c\u5e02|\u4e1c\u9633\u5e02|\u6c38\u5eb7\u5e02|\u6c5f\u5c71\u5e02|\u4e34\u6d77\u5e02|\u6e29\u5cad\u5e02|\u9f99\u6cc9\u5e02|\u6850\u57ce\u5e02|\u5929\u957f\u5e02|\u660e\u5149\u5e02|\u754c\u9996\u5e02|\u5b81\u56fd\u5e02|\u798f\u6e05\u5e02|\u957f\u4e50\u5e02|\u6c38\u5b89\u5e02|\u77f3\u72ee\u5e02|\u664b\u6c5f\u5e02|\u5357\u5b89\u5e02|\u9f99\u6d77\u5e02|\u90b5\u6b66\u5e02|\u6b66\u5937\u5c71|\u5efa\u74ef\u5e02|\u6f33\u5e73\u5e02|\u5efa\u9633\u5e02|\u798f\u5b89\u5e02|\u798f\u9f0e\u5e02|\u4e50\u5e73\u5e02|\u745e\u660c\u5e02|\u8d35\u6eaa\u5e02|\u745e\u91d1\u5e02|\u5357\u5eb7\u5e02|\u4e95\u5188\u5c71\u5e02|\u4e30\u57ce\u5e02|\u6a1f\u6811\u5e02|\u9ad8\u5b89\u5e02|\u5fb7\u5174\u5e02|\u7ae0\u4e18\u5e02|\u80f6\u5357\u5e02|\u80f6\u5dde\u5e02|\u5e73\u5ea6\u5e02|\u83b1\u897f\u5e02|\u5373\u58a8\u5e02|\u6ed5\u5dde\u5e02|\u9f99\u53e3\u5e02|\u83b1\u9633\u5e02|\u83b1\u5dde\u5e02|\u62db\u8fdc\u5e02|\u84ec\u83b1\u5e02|\u6816\u971e\u5e02|\u6d77\u9633\u5e02|\u9752\u5dde\u5e02|\u8bf8\u57ce\u5e02|\u5bff\u5149\u5e02|\u5b89\u4e18\u5e02|\u9ad8\u5bc6\u5e02|\u660c\u9091\u5e02|\u66f2\u961c\u5e02|\u5156\u5dde\u5e02|\u90b9\u57ce\u5e02|\u65b0\u6cf0\u5e02|\u80a5\u57ce\u5e02|\u4e73\u5c71\u5e02|\u6587\u767b\u5e02|\u8363\u6210\u5e02|\u4e50\u9675\u5e02|\u79b9\u57ce\u5e02|\u4e34\u6e05\u5e02|\u5de9\u4e49\u5e02|\u65b0\u90d1\u5e02|\u65b0\u5bc6\u5e02|\u767b\u5c01\u5e02|\u8365\u9633\u5e02|\u4e2d\u725f\u53bf|\u5043\u5e08\u5e02|\u6c5d\u5dde\u5e02|\u821e\u94a2\u5e02|\u6797\u5dde\u5e02|\u536b\u8f89\u5e02|\u8f89\u53bf\u5e02|\u6c81\u9633\u5e02|\u5b5f\u5dde\u5e02|\u79b9\u5dde\u5e02|\u957f\u845b\u5e02|\u4e49\u9a6c\u5e02|\u7075\u5b9d\u5e02|\u9093\u5dde\u5e02|\u6c38\u57ce\u5e02|\u9879\u57ce\u5e02|\u6d4e\u6e90\u5e02|\u5927\u51b6\u5e02|\u4e39\u6c5f\u53e3\u5e02|\u6d2a\u6e56\u5e02|\u77f3\u9996\u5e02|\u677e\u6ecb\u5e02|\u5b9c\u90fd\u5e02|\u5f53\u9633\u5e02|\u679d\u6c5f\u5e02|\u8001\u6cb3\u53e3\u5e02|\u67a3\u9633\u5e02|\u5b9c\u57ce\u5e02|\u949f\u7965\u5e02|\u5e94\u57ce\u5e02|\u5b89\u9646\u5e02|\u6c49\u5ddd\u5e02|\u9ebb\u57ce\u5e02|\u6b66\u7a74\u5e02|\u8d64\u58c1\u5e02|\u5e7f\u6c34\u5e02|\u4ed9\u6843\u5e02|\u5929\u95e8\u5e02|\u6f5c\u6c5f\u5e02|\u6069\u65bd\u5e02|\u5229\u5ddd\u5e02|\u6d4f\u9633\u5e02|\u91b4\u9675\u5e02|\u6e58\u4e61\u5e02|\u97f6\u5c71\u5e02|\u8012\u9633\u5e02|\u5e38\u5b81\u5e02|\u6b66\u5188\u5e02|\u4e34\u6e58\u5e02|\u6c68\u7f57\u5e02|\u6d25\u5e02\u5e02|\u6c85\u6c5f\u5e02|\u8d44\u5174\u5e02|\u6d2a\u6c5f\u5e02|\u51b7\u6c34\u6c5f\u5e02|\u6d9f\u6e90\u5e02|\u5409\u9996\u5e02|\u4ece\u5316\u5e02|\u589e\u57ce\u5e02|\u4e50\u660c\u5e02|\u5357\u96c4\u5e02|\u53f0\u5c71\u5e02|\u5f00\u5e73\u5e02|\u9e64\u5c71\u5e02|\u6069\u5e73\u5e02|\u5ec9\u6c5f\u5e02|\u96f7\u5dde\u5e02|\u5434\u5ddd\u5e02|\u9ad8\u5dde\u5e02|\u5316\u5dde\u5e02|\u4fe1\u5b9c\u5e02|\u9ad8\u8981\u5e02|\u56db\u4f1a\u5e02|\u5174\u5b81\u5e02|\u9646\u4e30\u5e02|\u9633\u6625\u5e02|\u82f1\u5fb7\u5e02|\u8fde\u5dde\u5e02|\u666e\u5b81\u5e02|\u7f57\u5b9a\u5e02|\u5c91\u6eaa\u5e02|\u4e1c\u5174\u5e02|\u6842\u5e73\u5e02|\u5317\u6d41\u5e02|\u5b9c\u5dde\u5e02|\u5408\u5c71\u5e02|\u51ed\u7965\u5e02|\u6587\u660c\u5e02|\u743c\u6d77\u5e02|\u4e07\u5b81\u5e02|\u4e94\u6307\u5c71\u5e02|\u4e1c\u65b9\u5e02|\u510b\u5dde\u5e02|\u90fd\u6c5f\u5830\u5e02|\u5f6d\u5dde\u5e02|\u909b\u5d03\u5e02|\u5d07\u5dde\u5e02|\u5e7f\u6c49\u5e02|\u4ec0\u90a1\u5e02|\u7ef5\u7af9\u5e02|\u6c5f\u6cb9\u5e02|\u5ce8\u7709\u5c71\u5e02|\u9606\u4e2d\u5e02|\u534e\u84e5\u5e02|\u4e07\u6e90\u5e02|\u7b80\u9633\u5e02|\u897f\u660c\u5e02|\u6e05\u9547\u5e02|\u8d64\u6c34\u5e02|\u4ec1\u6000\u5e02|\u94dc\u4ec1\u5e02|\u6bd5\u8282\u5e02|\u5174\u4e49\u5e02|\u51ef\u91cc\u5e02|\u90fd\u5300\u5e02|\u798f\u6cc9\u5e02|\u5b89\u5b81\u5e02|\u5ba3\u5a01\u5e02|\u4e2a\u65e7\u5e02|\u5f00\u8fdc\u5e02|\u666f\u6d2a\u5e02|\u695a\u96c4\u5e02|\u5927\u7406\u5e02|\u6f5e\u897f\u5e02|\u745e\u4e3d\u5e02|\u65e5\u5580\u5219\u5e02|\u5174\u5e73\u5e02|\u97e9\u57ce\u5e02|\u534e\u9634\u5e02|\u7389\u95e8\u5e02|\u6566\u714c\u5e02|\u4e34\u590f\u5e02|\u5408\u4f5c\u5e02|\u5fb7\u4ee4\u54c8\u5e02|\u683c\u5c14\u6728\u5e02|\u7075\u6b66\u5e02|\u9752\u94dc\u5ce1\u5e02|\u77f3\u6cb3\u5b50\u5e02|\u963f\u62c9\u5c14\u5e02|\u56fe\u6728\u8212\u514b\u5e02|\u4e94\u5bb6\u6e20\u5e02|\u5410\u9c81\u756a\u5e02|\u54c8\u5bc6\u5e02|\u548c\u7530\u5e02|\u963f\u514b\u82cf\u5e02|\u5580\u4ec0\u5e02|\u963f\u56fe\u4ec0\u5e02|\u5e93\u5c14\u52d2\u5e02|\u660c\u5409\u5e02|\u961c\u5eb7\u5e02|\u7c73\u6cc9\u5e02|\u535a\u4e50\u5e02|\u4f0a\u5b81\u5e02|\u594e\u5c6f\u5e02|\u5854\u57ce\u5e02|\u4e4c\u82cf\u5e02|\u963f\u52d2\u6cf0\u5e02|\u53f0\u5317\u5e02|\u9ad8\u96c4\u5e02|\u57fa\u9686\u5e02|\u53f0\u4e2d\u5e02|\u53f0\u5357\u5e02|\u65b0\u7af9\u5e02|\u5609\u4e49\u5e02";
    public static final String ADDRESS_PLUS_REGEX = "((?:(?:\u5185\u8499\u53e4|\u5e7f\u897f\u58ee\u65cf|\u897f\u85cf|\u5b81\u590f\u56de\u65cf|\u65b0\u7586\u7ef4\u543e\u5c14)\u81ea\u6cbb\u533a)|(?:(?:\u9999\u6e2f|\u6fb3\u95e8)\u7279\u522b\u884c\u653f\u533a))";
    public static final String NUMBER_PLUS_REGEX = "([0123456789\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe]{6,})";
    public static final String VALID_TIME_PLUS_REGEX = "(\u6709\u6548\u671f\u7531)";
    public static final String NAME_PLUS_REGEX = "(\u59d3s*\u540d|\u4eb2\u7231\u7684|\u5c0a\u656c\u7684)";
    public static final String CALL_PLUS_REGEX = "(\u5148\u751f|\u5973\u58eb)";
    public static final String COMPANY_NAME_PLUS_REGEX = "(\u5355\u4f4d\u540d\u79f0|\u5355\u4f4d[:\uff1a]{1})";
    public static final String ORGANIZATION_NAME_PLUS_REGEX = "(\u516c\u53f8|\u96c6\u56e2|\u7814\u7a76\u9662)";

    public static String regexDesensitizeSensitive(Object input) {
        return DesensitizeRegexUtil.regexDesensitizeSensitive(input, false);
    }

    public static String regexDesensitizeSensitive(Object input, boolean desensitizeAddress) {
        if (DesensitizeUtil.IS_EMPTY(input)) {
            return "";
        }
        String masked = input.toString();
        masked = DesensitizeRegexUtil.idCardDesensitize(masked);
        masked = DesensitizeRegexUtil.bankCardDesensitize(masked);
        masked = DesensitizeRegexUtil.phoneDesensitize(masked);
        masked = DesensitizeRegexUtil.licensePlateDesensitize(masked);
        masked = DesensitizeRegexUtil.passportDesensitize(masked);
        masked = DesensitizeRegexUtil.faxDesensitize(masked);
        masked = desensitizeAddress ? DesensitizeRegexUtil.addressDesensitize(masked) : masked;
        return masked;
    }

    public static String nameDesensitize(String nameInput) {
        if (DesensitizeUtil.IS_EMPTY(nameInput)) {
            return nameInput;
        }
        Pattern namePattern = Pattern.compile(CALL_PLUS_REGEX);
        Matcher nameMatcher = namePattern.matcher(nameInput);
        while (nameMatcher.find()) {
            String name = nameMatcher.group();
            int index = nameInput.indexOf(name);
            name = nameInput.substring(index > 1 ? index - 2 : index, index);
            nameInput = nameInput.replace(name, StringUtil.nCopies(FILLING, 2));
        }
        Pattern namePlusPattern = Pattern.compile(NAME_PLUS_REGEX);
        Matcher namePlusMatcher = namePlusPattern.matcher(nameInput);
        while (namePlusMatcher.find()) {
            String name = namePlusMatcher.group();
            int index = nameInput.indexOf(name);
            name = nameInput.substring(index + name.length(), index + name.length() + 2);
            nameInput = nameInput.replace(name, "**");
        }
        return nameInput;
    }

    public static String idCardDesensitize(String idCardInput) {
        if (StringUtil.isEmpty(idCardInput)) {
            return "";
        }
        return DesensitizeRegexUtil.idCardDesensitize(idCardInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 6, 4));
    }

    public static String idCardDesensitize(String idCardInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(idCardInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(idCardInput, function, ID_CARD_NUMBER_REGEX);
    }

    public static String bankCardDesensitize(String bankCardInput) {
        if (StringUtil.isEmpty(bankCardInput)) {
            return "";
        }
        return DesensitizeRegexUtil.bankCardDesensitize(bankCardInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 6, 4));
    }

    public static String bankCardDesensitize(String bankCardInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(bankCardInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(bankCardInput, function, BANK_CARD_NUMBER_REGEX);
    }

    public static String phoneDesensitize(String phoneInput) {
        if (StringUtil.isEmpty(phoneInput)) {
            return "";
        }
        return DesensitizeRegexUtil.phoneDesensitize(phoneInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 3, 4));
    }

    public static String phoneDesensitize(String phoneInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(phoneInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(phoneInput, function, PHONE_NUMBER_REGEX);
    }

    public static String addressDesensitize(String addressInput) {
        if (StringUtil.isEmpty(addressInput)) {
            return "";
        }
        Pattern provincePattern = Pattern.compile(PROVINCE_REGEX);
        Matcher provinceMatcher = provincePattern.matcher(addressInput);
        Pattern cityPattern = Pattern.compile(CITY_ADDRESS_REGEX);
        Matcher cityMatcher = cityPattern.matcher(addressInput);
        Pattern addressPattern = Pattern.compile(ADDRESS_PLUS_REGEX);
        Matcher addressMatcher = addressPattern.matcher(addressInput);
        while (provinceMatcher.find() && cityMatcher.find() || addressMatcher.find()) {
            String province = provinceMatcher.group();
            Pattern sybmlPattern = Pattern.compile(province + "[^,\uff0c\u3002.:\uff1a;\uff1b?\uff1f!\uff01]+");
            Matcher matcher = sybmlPattern.matcher(addressInput);
            String address = matcher.find() ? matcher.group() : province + addressInput.substring(addressInput.indexOf(province) + province.length(), 15);
            String maskedAddress = DesensitizeUtil.HEAD_RES(address, address.length() > 10 ? 10 : 3);
            addressInput = addressInput.replace(address, maskedAddress);
        }
        return addressInput;
    }

    public static String licensePlateDesensitize(String licensePlateInput) {
        if (StringUtil.isEmpty(licensePlateInput)) {
            return "";
        }
        return DesensitizeRegexUtil.licensePlateDesensitize(licensePlateInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 2, 2));
    }

    public static String licensePlateDesensitize(String licensePlateInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(licensePlateInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(licensePlateInput, function, LICENSE_PLATE_NUMBER_REGEX2);
    }

    public static String passportDesensitize(String passportInput) {
        if (StringUtil.isEmpty(passportInput)) {
            return "";
        }
        return DesensitizeRegexUtil.passportDesensitize(passportInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, 1, 3));
    }

    public static String passportDesensitize(String passportInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(passportInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(passportInput, function, PASSPORT_NUMBER_REGEX);
    }

    public static String faxDesensitize(String faxInput) {
        if (StringUtil.isEmpty(faxInput)) {
            return "";
        }
        return DesensitizeRegexUtil.faxDesensitize(faxInput, value -> DesensitizeUtil.HEAD_TAIL_RES(value, DesensitizeUtil.INDEX_OF(value, "-") + 1, 2));
    }

    public static String faxDesensitize(String faxInput, DesensitizationFunction<String> function) {
        if (StringUtil.isEmpty(faxInput)) {
            return "";
        }
        return DesensitizeRegexUtil.customDesensitize(faxInput, function, FAX_NUMBER_REGEX2);
    }

    public static String customDesensitize(String content, DesensitizationFunction<String> function, String ... regexes) {
        if (BeanUtils.isEmpty(content)) {
            return "";
        }
        if (BeanUtils.isEmpty(regexes) || regexes.length == 0 || BeanUtils.isEmpty(function)) {
            return content;
        }
        for (String regex : regexes) {
            if (StringUtil.isEmpty(regex)) continue;
            Pattern regexPattern = Pattern.compile(regex);
            Matcher regexMatcher = regexPattern.matcher(content);
            while (regexMatcher.find()) {
                String matched = regexMatcher.group();
                String masked = function.apply(matched);
                content = content.replace(matched, masked);
            }
        }
        return content;
    }

    public static String customDesensitize(String content, Map<String, DesensitizationFunction<String>> functionObj) {
        if (BeanUtils.isEmpty(content)) {
            return "";
        }
        if (BeanUtils.isEmpty(functionObj)) {
            return content;
        }
        for (String regex : functionObj.keySet()) {
            if (StringUtil.isEmpty(regex)) continue;
            Pattern regexPattern = Pattern.compile(regex);
            Matcher regexMatcher = regexPattern.matcher(content);
            while (regexMatcher.find()) {
                String matched = regexMatcher.group();
                DesensitizationFunction<String> desensitizationFunction = functionObj.get(regex);
                if (BeanUtils.isEmpty(desensitizationFunction)) continue;
                String masked = desensitizationFunction.apply(matched);
                content = content.replace(matched, masked);
            }
        }
        return content;
    }

    public static String mask(String content, int headLen, int tailLen) {
        if (StringUtil.isEmpty(content)) {
            return "";
        }
        int len = content.length();
        String prefix = content.substring(0, headLen);
        String suffix = content.substring(len - tailLen);
        String filling = StringUtil.nCopies(FILLING, len - prefix.length() - suffix.length());
        content = content.replace(content, String.format("%s%s%s", prefix, filling, suffix));
        return content;
    }
}

