/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.core.NestedExceptionUtils;

public class ExceptionUtil {
    public static String getExceptionMessage(Throwable e) {
        return ExceptionUtil.getMessage(e);
    }

    public static String getRootCauseMessage(Throwable e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        root = root == null ? e : root;
        return ExceptionUtil.getExceptionMessage(e);
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String msg = ExceptionUtil.extractMessageFromXML(th.getMessage());
        return StringUtils.defaultString((String)msg);
    }

    public static String extractMessageFromXML(String message) {
        if (StringUtil.isEmpty(message)) {
            return StringUtils.defaultString((String)message);
        }
        try {
            Pattern regex = Pattern.compile("^.*?<CommonResult>.*?<message>(.*?)</message>.*?</CommonResult>.*?$");
            Matcher regexMatcher = regex.matcher(message);
            if (regexMatcher.matches()) {
                return regexMatcher.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return message;
    }

    public static Throwable getRootCause(Throwable throwable) {
        return ExceptionUtils.getRootCause((Throwable)throwable);
    }

    public static Throwable getRootCauseOrSelf(Throwable throwable) {
        Throwable rootCause = NestedExceptionUtils.getRootCause((Throwable)throwable);
        if (rootCause == null) {
            return throwable;
        }
        return rootCause;
    }

    public static String getFullStackTrace(Throwable throwable) {
        return ExceptionUtils.getFullStackTrace((Throwable)throwable);
    }
}

