/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.exception.BaseException;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionUtil.class);
    private static final Pattern REGEX_BRACES = Pattern.compile("\\{(.*?)}", 98);
    private static final Pattern REGEX_BRACKETS = Pattern.compile("\\[(.*?)]", 98);

    public static String format(String expression, Map<String, Object> map) {
        if (StringUtil.isEmpty(expression)) {
            return expression;
        }
        expression = ExpressionUtil.format(expression, map, REGEX_BRACES);
        expression = ExpressionUtil.format(expression, map, REGEX_BRACKETS);
        return expression;
    }

    private static String format(String expression, Map<String, Object> map, Pattern pattern) {
        GroovyScriptEngine scriptEngine = AppUtil.getBean(GroovyScriptEngine.class);
        Matcher matcherBraces = pattern.matcher(expression);
        while (matcherBraces.find()) {
            String defaultValue;
            String rule = matcherBraces.group(1);
            if (map.containsKey(rule)) {
                expression = expression.replace(matcherBraces.group(0), BeanUtils.ObjectToString(map.get(rule)));
                continue;
            }
            try {
                defaultValue = scriptEngine.executeString(rule, map);
            }
            catch (Exception e) {
                LOGGER.error("\u89e3\u6790\u8868\u8fbe\u5f0f\u9519\u8bef\uff1a{}", (Object)rule, (Object)e);
                throw new BaseException("\u6267\u884c\u811a\u672c" + rule + "\u9519\u8bef");
            }
            expression = expression.replace(matcherBraces.group(0), defaultValue);
        }
        return expression;
    }
}

