/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import com.hotent.base.enums.ExtendJarType;
import com.hotent.base.exception.BaseException;
import com.hotent.base.groovy.IScript;
import com.hotent.base.groovy.IUserScript;
import com.hotent.base.jms.impl.JmsProducerEmptyImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

public class ExtendClassLoader
extends URLClassLoader {
    private static final Log logger = LogFactory.getLog(ExtendClassLoader.class);
    private JarFile jarFile;
    private static Map<String, Class> cacheClassMap = new HashMap<String, Class>();
    private static Map<String, String> cacheClassMd5Map = new HashMap<String, String>();
    private Map<String, byte[]> classBytesMap = new HashMap<String, byte[]>();

    public static Map<String, Class> resolutionJarClass(byte[] jarBytes, Integer type) throws IOException {
        File tempFile = File.createTempFile("tmp", ".jar");
        FileOutputStream fos = new FileOutputStream(tempFile);
        fos.write(jarBytes);
        fos.close();
        ExtendClassLoader classLoader = new ExtendClassLoader(new URL[]{tempFile.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Map<String, Class> init = classLoader.init(ExtendJarType.getByCode(type));
        classLoader.close();
        tempFile.delete();
        return init;
    }

    private ExtendClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        URL url = urls[0];
        String path = url.getPath();
        try {
            this.jarFile = new JarFile(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.findLoadedClass(name) == null) {
            return super.loadClass(name);
        }
        return cacheClassMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Class> init(ExtendJarType extendJarType) {
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        HashMap<String, String> Md5Map = new HashMap<String, String>();
        Enumeration<JarEntry> en = this.jarFile.entries();
        try {
            while (en.hasMoreElements()) {
                InputStream input;
                block27: {
                    JarEntry je = en.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".class")) continue;
                    String className = name.replace(".class", "").replaceAll("/", ".");
                    input = this.jarFile.getInputStream(je);
                    Throwable throwable = null;
                    try {
                        MessageDigest digest = null;
                        try {
                            digest = MessageDigest.getInstance("MD5");
                        }
                        catch (NoSuchAlgorithmException e) {
                            e.printStackTrace();
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int bufferSize = 4096;
                        byte[] buffer = new byte[bufferSize];
                        int bytesNumRead = 0;
                        while ((bytesNumRead = input.read(buffer)) != -1) {
                            baos.write(buffer, 0, bytesNumRead);
                            digest.update(buffer, 0, bytesNumRead);
                        }
                        byte[] classBytes = baos.toByteArray();
                        BigInteger bigInt = new BigInteger(1, digest.digest());
                        Md5Map.put(className, bigInt.toString(16));
                        this.classBytesMap.put(className, classBytes);
                        if (input == null) continue;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (input == null) throw throwable3;
                            if (throwable == null) {
                                input.close();
                                throw throwable3;
                            }
                            try {
                                input.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        input.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.jarFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Iterator<Map.Entry<String, byte[]>> iterator = this.classBytesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            String key = entry.getKey();
            Class<?> aClass = null;
            try {
                aClass = this.loadClass(key);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (aClass == null || ExtendJarType.SCRIPT.equals((Object)extendJarType) && !IUserScript.class.isAssignableFrom(aClass) && !IScript.class.isAssignableFrom(aClass)) continue;
            classMap.put((String)Md5Map.get(key), aClass);
        }
        return classMap;
    }

    public static void registerBean(List<Map<String, Class>> list, boolean isInterruptException) {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)AppUtil.getApplicaitonContext().getAutowireCapableBeanFactory();
        defaultListableBeanFactory.setAllowBeanDefinitionOverriding(true);
        for (Map<String, Class> collection : list) {
            for (Map.Entry<String, Class> next : collection.entrySet()) {
                Class cla = next.getValue();
                if (!ExtendClassLoader.isSpringBeanClass(cla)) continue;
                String beanName = ExtendClassLoader.getSimpleName(cla.getName());
                if (AppUtil.getBean(beanName) != null && !cacheClassMap.containsKey(beanName)) {
                    if (!isInterruptException) continue;
                    throw new RuntimeException(String.format("\u6ce8\u518c\u5916\u90e8bean\u3010%s\u3011\u5931\u8d25\uff0c\u548c\u7cfb\u7edf\u5df2\u6709\u7684bean\u91cd\u590d", cla.getClass().getName()));
                }
                try {
                    defaultListableBeanFactory.destroySingleton(beanName);
                    defaultListableBeanFactory.removeBeanDefinition(beanName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                defaultListableBeanFactory.registerBeanDefinition(beanName, ExtendClassLoader.getBeanDefinition(cla));
                Object registed = AppUtil.getBean(beanName);
                if (BeanUtils.isNotEmpty(registed)) {
                    cacheClassMd5Map.put(beanName, next.getKey());
                    cacheClassMap.put(beanName, next.getValue());
                    logger.info((Object)("regist extend bean success:" + beanName));
                    continue;
                }
                logger.error((Object)("regist extend bean fail and try again:" + beanName));
                ExtendClassLoader.registBeanAgain(defaultListableBeanFactory, next, isInterruptException);
            }
        }
        defaultListableBeanFactory.clearMetadataCache();
    }

    public static void registBeanAgain(DefaultListableBeanFactory defaultListableBeanFactory, Map.Entry<String, Class> next, boolean isInterruptException) {
        Class cla = next.getValue();
        String beanName = ExtendClassLoader.getSimpleName(cla.getName());
        defaultListableBeanFactory.registerBeanDefinition(beanName, ExtendClassLoader.getBeanDefinition(JmsProducerEmptyImpl.class));
        AppUtil.getBean(beanName);
        try {
            defaultListableBeanFactory.destroySingleton(beanName);
            defaultListableBeanFactory.removeBeanDefinition(beanName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultListableBeanFactory.registerBeanDefinition(beanName, ExtendClassLoader.getBeanDefinition(cla));
        Object registed = AppUtil.getBean(beanName);
        if (BeanUtils.isNotEmpty(registed)) {
            cacheClassMd5Map.put(beanName, next.getKey());
            cacheClassMap.put(beanName, cla);
            logger.info((Object)("regist extend bean success:" + beanName));
        } else {
            logger.error((Object)("regist extend bean again fail:" + beanName));
            if (isInterruptException) {
                throw new BaseException(String.format("\u6269\u5c55\u7c7b\u3010%s\u3011\u6ce8\u518c\u5931\u8d25", beanName));
            }
        }
    }

    private static BeanDefinition getBeanDefinition(Class cla) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)cla);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.setScope("singleton");
        beanDefinition.setLazyInit(false);
        return beanDefinition;
    }

    public static String getSimpleName(String className) {
        String beanName = StringUtils.uncapitalize((String)className);
        beanName = beanName.substring(beanName.lastIndexOf(".") + 1);
        beanName = StringUtils.uncapitalize((String)beanName);
        return beanName;
    }

    public static boolean isSpringBeanClass(Class<?> cla) {
        if (cla == null) {
            return false;
        }
        if (cla.isInterface()) {
            return false;
        }
        if (Modifier.isAbstract(cla.getModifiers())) {
            return false;
        }
        if (cla.getAnnotation(Component.class) != null) {
            return true;
        }
        if (cla.getAnnotation(Repository.class) != null) {
            return true;
        }
        return cla.getAnnotation(Service.class) != null;
    }

    public Map<String, Class> getClassMap() {
        return cacheClassMap;
    }

    public static Map<String, String> getClassMd5Map() {
        return cacheClassMd5Map;
    }

    public static Class getClassByName(String name) {
        if (cacheClassMap.containsKey(name = ExtendClassLoader.getSimpleName(name))) {
            return cacheClassMap.get(name);
        }
        return null;
    }

    public static String getClassMd5ByName(String name) {
        if (cacheClassMd5Map.containsKey(name = ExtendClassLoader.getSimpleName(name)) && cacheClassMap.containsKey(name)) {
            return cacheClassMd5Map.get(name);
        }
        return null;
    }

    public static void removeRegistedBean(String beanNames) {
        if (StringUtil.isEmpty(beanNames)) {
            return;
        }
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)AppUtil.getApplicaitonContext().getAutowireCapableBeanFactory();
        for (String beanName : beanNames.split(",")) {
            if (!cacheClassMd5Map.containsKey(beanName) || !cacheClassMap.containsKey(beanName)) continue;
            try {
                defaultListableBeanFactory.destroySingleton(beanName);
                defaultListableBeanFactory.removeBeanDefinition(beanName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AppUtil.getBean(beanName) != null) continue;
            cacheClassMd5Map.remove(beanName);
            cacheClassMap.remove(beanName);
        }
    }

    public static boolean isPresent(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

