/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.base.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;

public class GoogleAuthenticator {
    public static final int SECRET_SIZE = 10;
    public static final String SEED = "g8GjEvTbW5oVSV7avLBdwIHqGlUYNzKFI7izOF8GwLDVKs2m0QN7vxRs2im5MDaNCWGmcD2rvcZx";
    public static final String RANDOM_NUMBER_ALGORITHM = "SHA1PRNG";
    public static final String format = "otpauth://totp/%s:%s?secret=%s&issuer=%s";
    int window_size = 3;

    public void setWindowSize(int s) {
        if (s >= 1 && s <= 17) {
            this.window_size = s;
        }
    }

    public static Boolean authcode(String codes, String savedSecret) {
        try {
            long code = Long.parseLong(codes);
            long t = System.currentTimeMillis();
            GoogleAuthenticator ga = new GoogleAuthenticator();
            ga.setWindowSize(15);
            boolean r = ga.check_code(savedSecret, code, t);
            return r;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String generateSecretKey() {
        SecureRandom sr = null;
        try {
            sr = SecureRandom.getInstance(RANDOM_NUMBER_ALGORITHM);
            sr.setSeed(Base64.decodeBase64((String)SEED));
            byte[] buffer = sr.generateSeed(10);
            Base32 codec = new Base32();
            byte[] bEncodedKey = codec.encode(buffer);
            String encodedKey = new String(bEncodedKey);
            return encodedKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getQRBarcodeURL(String user, String secret, String host) {
        return String.format(format, host, user, secret, host);
    }

    public boolean check_code(String secret, long code, long timeMsec) {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secret);
        long t = timeMsec / 1000L / 30L;
        for (int i = -this.window_size; i <= this.window_size; ++i) {
            long hash;
            try {
                hash = GoogleAuthenticator.verify_code(decodedKey, t + (long)i);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    private static int verify_code(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }
}

